/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.dom.converters;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.web.ServletPathReferenceProvider;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.struts.StrutsBundle;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.TilesModel;
import com.intellij.struts.dom.Action;
import com.intellij.struts.dom.Controller;
import com.intellij.struts.dom.Forward;
import com.intellij.struts.dom.SetProperty;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.struts.dom.converters.StrutsPagesReferenceProvider;
import com.intellij.struts.dom.converters.StrutsPathReferenceConverter;
import com.intellij.struts.dom.tiles.Definition;
import com.intellij.struts.inplace.reference.XmlValueReference;
import com.intellij.struts.inplace.reference.config.ForwardReferenceProvider;
import com.intellij.struts.inplace.reference.config.TilesReferenceProvider;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.highlighting.ResolvingElementQuickFix;
import icons.StrutsApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsPathReferenceConverterImpl
extends StrutsPathReferenceConverter {
    @NonNls
    private static final String INPUT_ATTRIBUTE = "input";
    @NonNls
    private static final String INPUT_FORWARD = "inputForward";
    private static final TilesReferenceProvider TILES_REFERENCE_PROVIDER = new TilesReferenceProvider(true);
    private static final ForwardReferenceProvider FORWARD_REFERENCE_PROVIDER = new ForwardReferenceProvider(true);
    private final PathReferenceProvider myTilesPathsProvider = new PathReferenceProvider(){

        @Nullable
        public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
            Definition definition;
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/struts/dom/converters/StrutsPathReferenceConverterImpl$1", "getPathReference"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/dom/converters/StrutsPathReferenceConverterImpl$1", "getPathReference"));
            }
            TilesModel model = StrutsManager.getInstance().getTiles(element);
            if (model != null && (definition = model.findDefinition(path)) != null) {
                return new PathReference(path, (Function)new ConstantFunction((Object)StrutsApiIcons.Tiles.Tile)){

                    @Nullable
                    public PsiElement resolve() {
                        return definition.ensureTagExists();
                    }
                };
            }
            return null;
        }

        public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts/dom/converters/StrutsPathReferenceConverterImpl$1", "createReferences"));
            }
            if (references == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/struts/dom/converters/StrutsPathReferenceConverterImpl$1", "createReferences"));
            }
            Object[] refs = TILES_REFERENCE_PROVIDER.getReferencesByElement(psiElement);
            ContainerUtil.addAll(references, (Object[])refs);
            return false;
        }
    };
    private final PathReferenceProvider myForwardsPathsProvider = new PathReferenceProvider(){

        public boolean createReferences(final @NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts/dom/converters/StrutsPathReferenceConverterImpl$2", "createReferences"));
            }
            if (references == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/struts/dom/converters/StrutsPathReferenceConverterImpl$2", "createReferences"));
            }
            final StrutsModel model = StrutsManager.getInstance().getStrutsModel(psiElement);
            if (model != null) {
                XmlValueReference reference = new XmlValueReference((XmlAttributeValue)psiElement, FORWARD_REFERENCE_PROVIDER){

                    @Override
                    @Nullable
                    protected PsiElement doResolve() {
                        String url = this.getValue();
                        url = WebUtil.trimURL((String)url);
                        Forward forward = null;
                        DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement(((XmlAttribute)this.getElement().getParent()).getParent());
                        if (element instanceof Action) {
                            forward = (Forward)DomUtil.findByName((Collection)((Action)element).getForwards(), (String)url);
                        }
                        if (forward == null) {
                            forward = model.findForward(url);
                        }
                        return forward == null ? null : forward.getXmlTag();
                    }

                    @Override
                    @Nullable
                    protected Object[] doGetVariants() {
                        ArrayList forwards = new ArrayList(model.getGlobalForwards());
                        DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement(((XmlAttribute)this.getElement().getParent()).getParent());
                        assert (element instanceof Action);
                        forwards.addAll(((Action)element).getForwards());
                        return ElementPresentationManager.getInstance().createVariants(forwards);
                    }

                    @Override
                    @Nullable
                    protected DomElement getScope() {
                        return ((StrutsConfig)model.getMergedModel()).getGlobalForwards();
                    }

                    @Override
                    public LocalQuickFix[] getQuickFixes() {
                        ResolvingElementQuickFix quickFix = this.createResolvingFix(this.getScope());
                        if (quickFix != null) {
                            DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement(((XmlAttribute)this.getElement().getParent()).getParent());
                            assert (element instanceof Action);
                            ResolvingElementQuickFix local = this.createResolvingFix(element);
                            assert (local != null);
                            local.setTypeName(StrutsBundle.message((String)"local.forward", (Object[])new Object[0]));
                            return new LocalQuickFix[]{quickFix, local};
                        }
                        return LocalQuickFix.EMPTY_ARRAY;
                    }
                };
                references.add(reference);
            }
            return false;
        }

        @Nullable
        public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/struts/dom/converters/StrutsPathReferenceConverterImpl$2", "getPathReference"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/dom/converters/StrutsPathReferenceConverterImpl$2", "getPathReference"));
            }
            return new PathReference(path, (Function)new ConstantFunction((Object)StrutsApiIcons.Forward));
        }
    };
    private final PathReferenceProvider myStrutsPagesPathsProvider = new StrutsPagesReferenceProvider();
    private final PathReferenceProvider[] myProviders = new PathReferenceProvider[]{PathReferenceManager.getInstance().getGlobalWebPathReferenceProvider(), this.myStrutsPagesPathsProvider, this.myTilesPathsProvider, new ServletPathReferenceProvider()};

    public PathReference fromString(@Nullable String s, ConvertContext context) {
        WebFacet webFacet;
        Module module = context.getModule();
        if (module == null || s == null) {
            return null;
        }
        XmlElement xmlElement = context.getReferenceXmlElement();
        if (xmlElement == null) {
            return null;
        }
        if (StrutsPathReferenceConverterImpl.isInputForward((PsiElement)xmlElement) && (webFacet = (WebFacet)JavaeeFacetUtil.getInstance().getJavaeeFacet(context, WebFacet.ID)) != null) {
            return this.myForwardsPathsProvider.getPathReference(s, (PsiElement)xmlElement);
        }
        return PathReferenceManager.getInstance().getCustomPathReference(s, module, (PsiElement)xmlElement, this.myProviders);
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts/dom/converters/StrutsPathReferenceConverterImpl", "createReferences"));
        }
        PsiElement parent = psiElement.getParent();
        if (StrutsPathReferenceConverterImpl.isInputForward(parent)) {
            PsiReference[] psiReferenceArray = PathReferenceManager.getReferencesFromProvider((PathReferenceProvider)this.myForwardsPathsProvider, (PsiElement)psiElement, (boolean)soft);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/dom/converters/StrutsPathReferenceConverterImpl", "createReferences"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createCustomReferences(psiElement, soft, this.myProviders);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/dom/converters/StrutsPathReferenceConverterImpl", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static boolean isInputForward(PsiElement psiElement) {
        StrutsModel model;
        if (psiElement instanceof XmlAttribute && ((XmlAttribute)psiElement).getName().equals(INPUT_ATTRIBUTE) && (model = StrutsManager.getInstance().getStrutsModel(psiElement)) != null) {
            Controller controller = ((StrutsConfig)model.getMergedModel()).getController();
            Boolean value = (Boolean)controller.getInputForward().getValue();
            if (value == null) {
                for (SetProperty property : controller.getSetProperties()) {
                    String s = property.getProperty().getStringValue();
                    if (s == null || !s.equals(INPUT_FORWARD)) continue;
                    String val = property.getValue().getStringValue();
                    return val != null && Boolean.parseBoolean(val);
                }
            } else {
                return value;
            }
        }
        return false;
    }
}

