/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.diagram;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.pom.Navigatable;
import com.intellij.struts.diagram.StrutsGraphDataModel;
import com.intellij.struts.diagram.StrutsGraphNodeRenderer;
import com.intellij.struts.diagram.StrutsObject;
import com.intellij.util.OpenSourceUtil;
import org.jetbrains.annotations.NotNull;

public class StrutsPresentationModel
extends BasicGraphPresentationModel<StrutsObject, StrutsObject> {
    private StrutsGraphNodeRenderer myNodeCellRenderer;
    private final Project myProject;
    private final ModificationTracker myTracker;

    public StrutsPresentationModel(Project project, ModificationTracker tracker, StrutsGraphDataModel dataModel, Graph graph) {
        super(graph);
        this.myProject = project;
        this.myTracker = tracker;
    }

    public void customizeSettings(Graph2DView view, EditMode editMode) {
        editMode.allowEdgeCreation(false);
    }

    @NotNull
    public NodeRealizer getNodeRealizer(StrutsObject strutsObject) {
        NodeRealizer nodeRealizer = GraphViewUtil.createNodeRealizer((String)"Struts", (NodeCellRenderer)this.getNodeCellRenderer());
        if (nodeRealizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/diagram/StrutsPresentationModel", "getNodeRealizer"));
        }
        return nodeRealizer;
    }

    public boolean editNode(StrutsObject strutsObject) {
        if (strutsObject.getPsiElement() instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)strutsObject.getPsiElement()});
            return true;
        }
        return super.editNode((Object)strutsObject);
    }

    public boolean editEdge(StrutsObject strutsObject) {
        if (strutsObject.getPsiElement() instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)strutsObject.getPsiElement()});
            return true;
        }
        return super.editNode((Object)strutsObject);
    }

    protected DefaultActionGroup getCommonActionGroup() {
        DefaultActionGroup group = super.getCommonActionGroup();
        AnAction anAction = ActionManager.getInstance().getAction("EditSource");
        group.add((AnAction)Separator.getInstance(), Constraints.FIRST);
        group.add(anAction, Constraints.FIRST);
        return group;
    }

    public String getEdgeTooltip(StrutsObject strutsObject) {
        return super.getEdgeTooltip((Object)strutsObject);
    }

    public String getNodeTooltip(StrutsObject strutsObject) {
        return super.getNodeTooltip((Object)strutsObject);
    }

    public EdgeCreationPolicy<StrutsObject> getEdgeCreationPolicy() {
        return super.getEdgeCreationPolicy();
    }

    public Project getProject() {
        return this.myProject;
    }

    public ModificationTracker getTracker() {
        return this.myTracker;
    }

    public StrutsGraphNodeRenderer getNodeCellRenderer() {
        if (this.myNodeCellRenderer == null) {
            this.myNodeCellRenderer = new StrutsGraphNodeRenderer((GraphBuilder<StrutsObject, StrutsObject>)this.getGraphBuilder(), this.getProject(), this.getTracker());
        }
        return this.myNodeCellRenderer;
    }
}

