/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.core;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class JDOMClassExternalizer {
    public static void writeExternal(Object data, Element parentNode) throws WriteExternalException {
        Field[] fields = data.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            Element element;
            String value;
            Field field;
            block23: {
                field = fields[i];
                if (field.getName().indexOf(36) >= 0) continue;
                int modifiers = field.getModifiers();
                value = null;
                if ((modifiers & 1) == 0 || (modifiers & 8) != 0) continue;
                field.setAccessible(true);
                Class<?> type = field.getType();
                try {
                    if (type.isPrimitive()) {
                        if (type.equals(Byte.TYPE)) {
                            value = Byte.toString(field.getByte(data));
                        } else if (type.equals(Short.TYPE)) {
                            value = Short.toString(field.getShort(data));
                        } else if (type.equals(Integer.TYPE)) {
                            value = Integer.toString(field.getInt(data));
                        } else if (type.equals(Long.TYPE)) {
                            value = Long.toString(field.getLong(data));
                        } else if (type.equals(Float.TYPE)) {
                            value = Float.toString(field.getFloat(data));
                        } else if (type.equals(Double.TYPE)) {
                            value = Double.toString(field.getDouble(data));
                        } else if (type.equals(Character.TYPE)) {
                            value = "" + field.getChar(data);
                        } else {
                            if (!type.equals(Boolean.TYPE)) continue;
                            value = field.getBoolean(data) ? "true" : "false";
                        }
                        break block23;
                    }
                    if (type.equals(String.class)) {
                        value = (String)field.get(data);
                        break block23;
                    }
                    if (type.equals(Color.class)) {
                        Color color = (Color)field.get(data);
                        if (color != null) {
                            value = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
                        }
                        break block23;
                    }
                    if (Collection.class.isAssignableFrom(type)) {
                        element = new Element("option");
                        parentNode.addContent(element);
                        element.setAttribute("name", field.getName());
                        Collection coll = (Collection)field.get(data);
                        Iterator it = coll.iterator();
                        while (it.hasNext()) {
                            Element val = new Element("option");
                            val.addContent((String)it.next());
                            element.addContent(val);
                        }
                        break block23;
                    }
                    element = new Element("option");
                    parentNode.addContent(element);
                    element.setAttribute("name", field.getName());
                    Object domValue = field.get(data);
                    if (domValue == null) continue;
                    Element valueElement = new Element("value");
                    element.addContent(valueElement);
                    JDOMClassExternalizer.writeExternal(domValue, valueElement);
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            element = new Element("option");
            parentNode.addContent(element);
            element.setAttribute("name", field.getName());
            if (value == null) continue;
            element.setAttribute("value", value);
        }
    }

    public static void readExternal(Object data, Element parentNode) throws InvalidDataException {
        if (parentNode == null) {
            return;
        }
        for (Element e : parentNode.getChildren("option")) {
            String fieldName = e.getAttributeValue("name");
            if (fieldName == null) {
                throw new InvalidDataException();
            }
            try {
                Field field = data.getClass().getField(fieldName);
                Class<?> type = field.getType();
                int modifiers = field.getModifiers();
                if ((modifiers & 1) == 0 || (modifiers & 8) != 0) continue;
                field.setAccessible(true);
                String value = e.getAttributeValue("value");
                if (type.isPrimitive()) {
                    if (value == null) {
                        throw new InvalidDataException();
                    }
                    if (type.equals(Byte.TYPE)) {
                        try {
                            field.setByte(data, Byte.parseByte(value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Short.TYPE)) {
                        try {
                            field.setShort(data, Short.parseShort(value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Integer.TYPE)) {
                        try {
                            field.setInt(data, Integer.parseInt(value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Long.TYPE)) {
                        try {
                            field.setLong(data, Long.parseLong(value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Float.TYPE)) {
                        try {
                            field.setFloat(data, Float.parseFloat(value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Double.TYPE)) {
                        try {
                            field.setDouble(data, Double.parseDouble(value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Character.TYPE)) {
                        if (value.length() != 1) {
                            throw new InvalidDataException();
                        }
                        field.setChar(data, value.charAt(0));
                        continue;
                    }
                    if (type.equals(Boolean.TYPE)) {
                        if (value.equals("true")) {
                            field.setBoolean(data, true);
                            continue;
                        }
                        if (value.equals("false")) {
                            field.setBoolean(data, false);
                            continue;
                        }
                        throw new InvalidDataException();
                    }
                    throw new InvalidDataException();
                }
                if (type.equals(String.class)) {
                    field.set(data, value);
                    continue;
                }
                if (type.equals(Color.class)) {
                    if (value != null) {
                        try {
                            int rgb = Integer.parseInt(value, 16);
                            field.set(data, new Color(rgb));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            System.out.println("value=" + value);
                            throw new InvalidDataException();
                        }
                    }
                    field.set(data, null);
                    continue;
                }
                if (Collection.class.isAssignableFrom(type)) {
                    Collection coll = (Collection)field.get(data);
                    List options = e.getChildren("option");
                    if (options == null) continue;
                    for (Element val : options) {
                        String text = val.getText();
                        coll.add(text);
                    }
                    continue;
                }
                Element val = e.getChild("value");
                JDOMClassExternalizer.readExternal(field.get(data), val);
            }
            catch (NoSuchFieldException ex) {
            }
            catch (SecurityException ex) {
                throw new InvalidDataException();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                throw new InvalidDataException();
            }
        }
    }
}

