/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts;

import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.config.StrutsConfiguration;
import com.intellij.struts.propertyInspector.DomPropertyInspector;
import com.intellij.struts.tree.DomBrowser;
import com.intellij.struts.tree.StrutsDomTree;
import com.intellij.struts.tree.TilesDomTree;
import com.intellij.struts.tree.ValidatorDomTree;
import com.intellij.struts.ui.SmartTabbedPane;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.Alarm;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.tree.AbstractDomElementNode;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsView
implements Disposable {
    private static final int STRUTS_TAB = 0;
    private static final int TILES_TAB = 1;
    private static final int VALIDATION_TAB = 2;
    private final Splitter mySplitter;
    private final SmartTabbedPane myTabbedPane;
    @NotNull
    private final DomBrowser myStrutsBrowser;
    @NotNull
    private final DomBrowser myTilesBrowser;
    @NotNull
    private final DomBrowser myValidatorBrowser;
    private final MyAutoScrollFromSourceHandler myAutoScrollFromSourceHandler;

    public StrutsView(Project project) {
        this.myStrutsBrowser = new DomBrowser(new StrutsDomTree(project));
        this.myTilesBrowser = new DomBrowser(new TilesDomTree(project));
        this.myValidatorBrowser = new DomBrowser(new ValidatorDomTree(project));
        Disposer.register((Disposable)this, (Disposable)this.myStrutsBrowser);
        Disposer.register((Disposable)this, (Disposable)this.myTilesBrowser);
        Disposer.register((Disposable)this, (Disposable)this.myValidatorBrowser);
        this.myTabbedPane = new SmartTabbedPane();
        this.myTabbedPane.addTab("Struts", null, this.myStrutsBrowser.getComponent(), 0);
        this.myTabbedPane.addTab("Tiles", null, this.myTilesBrowser.getComponent(), 1);
        this.myTabbedPane.addTab("Validator", null, this.myValidatorBrowser.getComponent(), 2);
        this.mySplitter = new MySplitter();
        this.mySplitter.setDividerWidth(3);
        final MyAutoScrollToSourceHandler scrollToSourceHandler = new MyAutoScrollToSourceHandler();
        scrollToSourceHandler.install((JTree)this.myStrutsBrowser.getTree());
        scrollToSourceHandler.install((JTree)this.myTilesBrowser.getTree());
        scrollToSourceHandler.install((JTree)this.myValidatorBrowser.getTree());
        this.myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler(project, this);
        this.myAutoScrollFromSourceHandler.install();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)scrollToSourceHandler.createToggleAction());
        actionGroup.add((AnAction)this.myAutoScrollFromSourceHandler.createToggleAction());
        actionGroup.addSeparator();
        actionGroup.add((AnAction)new ExpandAllAction(null){

            public void actionPerformed(AnActionEvent e) {
                DomBrowser currentBrowser = StrutsView.this.getCurrentBrowser();
                if (currentBrowser != null) {
                    this.myTree = currentBrowser.getTree();
                    super.actionPerformed(e);
                }
            }
        });
        actionGroup.add((AnAction)new CollapseAllAction(null){

            public void actionPerformed(AnActionEvent e) {
                DomBrowser currentBrowser = StrutsView.this.getCurrentBrowser();
                if (currentBrowser != null) {
                    this.myTree = currentBrowser.getTree();
                    super.actionPerformed(e);
                }
            }
        });
        actionGroup.addSeparator();
        actionGroup.add((AnAction)new ContextHelpAction());
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("", (ActionGroup)actionGroup, true);
        JPanel upper = new JPanel(new BorderLayout());
        upper.add((Component)((Object)this.myTabbedPane), "Center");
        upper.add((Component)actionToolbar.getComponent(), "North");
        this.mySplitter.setFirstComponent((JComponent)upper);
        final DomPropertyInspector table = new DomPropertyInspector();
        Disposer.register((Disposable)this, (Disposable)table);
        this.mySplitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)table)));
        TreeListener.install(table, this.myStrutsBrowser.getTree());
        TreeListener.install(table, this.myTilesBrowser.getTree());
        TreeListener.install(table, this.myValidatorBrowser.getTree());
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SimpleNode simpleNode;
                DomElement current = null;
                DomBrowser browser = StrutsView.this.getCurrentBrowser();
                if (browser != null && (simpleNode = browser.getTree().getSelectedNode()) instanceof AbstractDomElementNode) {
                    current = ((AbstractDomElementNode)simpleNode).getDomElement();
                }
                table.setElement(current);
                StrutsView.this.update();
                scrollToSourceHandler.scrollToSource();
            }
        });
    }

    @Nullable
    protected DomBrowser getCurrentBrowser() {
        switch (this.myTabbedPane.getVirtualIndex()) {
            case 0: {
                return this.myStrutsBrowser;
            }
            case 1: {
                return this.myTilesBrowser;
            }
            case 2: {
                return this.myValidatorBrowser;
            }
        }
        return null;
    }

    public void update() {
        DomBrowser browser = this.getCurrentBrowser();
        if (browser != null) {
            browser.update();
        }
    }

    @NotNull
    public JComponent getComponent() {
        Splitter splitter = this.mySplitter;
        if (splitter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/StrutsView", "getComponent"));
        }
        return splitter;
    }

    public void openDefault() {
        this.myStrutsBrowser.openDefault();
        if (this.myTilesBrowser != null) {
            this.myTilesBrowser.openDefault();
        }
        if (this.myValidatorBrowser != null) {
            this.myValidatorBrowser.openDefault();
        }
    }

    public void dispose() {
    }

    private class MySplitter
    extends Splitter
    implements DataProvider {
        public MySplitter() {
            super(true);
        }

        @NonNls
        public Object getData(@NonNls String dataId) {
            if (DataConstants.HELP_ID.equals(dataId)) {
                switch (StrutsView.this.myTabbedPane.getVirtualIndex()) {
                    case 0: {
                        return "reference.tool.windows.struts.assistant.tab.struts";
                    }
                    case 1: {
                        return "reference.tool.windows.struts.assistant.tab.tiles";
                    }
                    case 2: {
                        return "reference.tool.windows.struts.assistant.tab.validator";
                    }
                }
                return null;
            }
            return null;
        }
    }

    private static class TreeListener
    implements TreeSelectionListener,
    TreeModelListener {
        private final DomPropertyInspector myTable;
        private final SimpleTree myTree;

        public static void install(DomPropertyInspector table, SimpleTree tree) {
            TreeListener listener = new TreeListener(table, tree);
            tree.getSelectionModel().addTreeSelectionListener(listener);
            tree.getModel().addTreeModelListener(listener);
        }

        public TreeListener(DomPropertyInspector table, SimpleTree tree) {
            this.myTable = table;
            this.myTree = tree;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.setElement();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.setElement();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.setElement();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.setElement();
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.setElement();
        }

        private void setElement() {
            DomElement element = null;
            SimpleNode node = this.myTree.getSelectedNode();
            if (node instanceof AbstractDomElementNode && (element = ((AbstractDomElementNode)node).getDomElement()) != null && !element.isValid()) {
                element = null;
            }
            this.myTable.setElement(element);
        }
    }

    public class MyAutoScrollToSourceHandler
    extends AutoScrollToSourceHandler {
        protected boolean isAutoScrollMode() {
            return StrutsConfiguration.getInstance().autoscrollToSource;
        }

        protected void setAutoScrollMode(boolean state) {
            StrutsConfiguration.getInstance().autoscrollToSource = state;
            if (state) {
                this.scrollToSource();
            }
        }

        public void scrollToSource() {
            DomBrowser browser;
            if (this.isAutoScrollMode() && (browser = StrutsView.this.getCurrentBrowser()) != null) {
                this.scrollToSource((Component)browser.getTree());
            }
        }
    }

    protected class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        private final Alarm myAutoscrollAlarm;
        private TextEditor myEditor;
        private CaretListener myListener;

        public MyAutoScrollFromSourceHandler(@Nullable Project project, Disposable parentDisposable) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/struts/StrutsView$MyAutoScrollFromSourceHandler", "<init>"));
            }
            super(project, StrutsView.this.getComponent(), parentDisposable);
            this.myAutoscrollAlarm = new Alarm();
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/struts/StrutsView$MyAutoScrollFromSourceHandler", "selectElementFromEditor"));
            }
            this.removeCaretListener();
            if (editor instanceof TextEditor) {
                this.myEditor = (TextEditor)editor;
                this.myListener = new CaretAdapter(){

                    public void caretPositionChanged(CaretEvent e) {
                        if (StrutsView.this.getComponent().isShowing() && MyAutoScrollFromSourceHandler.this.isAutoScrollEnabled()) {
                            MyAutoScrollFromSourceHandler.this.scrollFromSource(e.getEditor());
                        }
                    }
                };
                this.scrollFromSource(this.myEditor.getEditor());
                this.myEditor.getEditor().getCaretModel().addCaretListener(this.myListener);
            }
        }

        private void removeCaretListener() {
            if (this.myEditor != null) {
                this.myEditor.getEditor().getCaretModel().removeCaretListener(this.myListener);
                this.myEditor = null;
                this.myListener = null;
            }
        }

        protected void scrollToSource() {
        }

        protected void scrollFromSource(Editor e) {
            if (!StrutsView.this.getComponent().isShowing() || !this.isAutoScrollEnabled()) {
                return;
            }
            this.myAutoscrollAlarm.cancelAllRequests();
            this.myAutoscrollAlarm.addRequest(() -> {
                DomElement domElement;
                if (!e.getContentComponent().hasFocus()) {
                    return;
                }
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(e.getDocument());
                boolean autoscrollToSource = StrutsConfiguration.getInstance().autoscrollToSource;
                StrutsConfiguration.getInstance().autoscrollToSource = false;
                DomBrowser currentBrowser = this.selectFile(psiFile);
                StrutsConfiguration.getInstance().autoscrollToSource = autoscrollToSource;
                if (currentBrowser == null) {
                    return;
                }
                int offset = e.getCaretModel().getOffset();
                assert (psiFile != null);
                XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, XmlTag.class, (boolean)false);
                if (tag != null && (domElement = DomManager.getDomManager((Project)this.myProject).getDomElement(tag)) != null) {
                    currentBrowser.setSelectedDomElement(domElement);
                }
            }, 500);
        }

        @Nullable
        protected DomBrowser selectFile(PsiFile file) {
            if (StrutsView.this.myStrutsBrowser.hasFile(file)) {
                StrutsView.this.myTabbedPane.setVirtualIndex(0);
                return StrutsView.this.myStrutsBrowser;
            }
            if (StrutsView.this.myTilesBrowser.hasFile(file)) {
                StrutsView.this.myTabbedPane.setVirtualIndex(1);
                return StrutsView.this.myTilesBrowser;
            }
            if (StrutsView.this.myValidatorBrowser.hasFile(file)) {
                StrutsView.this.myTabbedPane.setVirtualIndex(2);
                return StrutsView.this.myValidatorBrowser;
            }
            return null;
        }

        protected boolean isAutoScrollEnabled() {
            return StrutsConfiguration.getInstance().autoscrollFromSource;
        }

        protected void setAutoScrollEnabled(boolean state) {
            StrutsConfiguration.getInstance().autoscrollFromSource = state;
            if (state && this.myEditor != null) {
                this.scrollFromSource(this.myEditor.getEditor());
            }
        }

        public void dispose() {
            super.dispose();
            this.removeCaretListener();
        }
    }
}

