/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.struts.StrutsDomFactory;
import com.intellij.struts.StrutsPluginDomFactory;
import com.intellij.struts.TilesDomFactory;
import com.intellij.struts.TilesModel;
import com.intellij.struts.ValidationModel;
import com.intellij.struts.ValidatorDomFactory;
import com.intellij.struts.dom.tiles.TilesDefinitions;
import com.intellij.struts.dom.validator.FormValidation;
import org.jetbrains.annotations.NotNull;

public class StrutsProjectComponent {
    private final StrutsDomFactory myStrutsFactory;
    private final StrutsPluginDomFactory<TilesDefinitions, TilesModel> myTilesFactory;
    private final StrutsPluginDomFactory<FormValidation, ValidationModel> myValidatorFactory;

    @NotNull
    public static StrutsProjectComponent getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/struts/StrutsProjectComponent", "getInstance"));
        }
        StrutsProjectComponent strutsProjectComponent = (StrutsProjectComponent)ServiceManager.getService((Project)project, StrutsProjectComponent.class);
        if (strutsProjectComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/StrutsProjectComponent", "getInstance"));
        }
        return strutsProjectComponent;
    }

    public StrutsProjectComponent(Project project) {
        this.myStrutsFactory = new StrutsDomFactory(project);
        this.myTilesFactory = new TilesDomFactory(this.myStrutsFactory, project);
        this.myValidatorFactory = new ValidatorDomFactory(this.myStrutsFactory, project);
    }

    public StrutsDomFactory getStrutsFactory() {
        return this.myStrutsFactory;
    }

    public StrutsPluginDomFactory<TilesDefinitions, TilesModel> getTilesFactory() {
        return this.myTilesFactory;
    }

    public StrutsPluginDomFactory<FormValidation, ValidationModel> getValidatorFactory() {
        return this.myValidatorFactory;
    }
}

