/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references.injector;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.util.ProcessingContext;
import icons.SpringApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SpringPlaceholderReferenceInjector
extends ReferenceInjector {
    @NotNull
    public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull ProcessingContext context, @NotNull TextRange range) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/references/injector/SpringPlaceholderReferenceInjector", "getReferences"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/references/injector/SpringPlaceholderReferenceInjector", "getReferences"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spring/references/injector/SpringPlaceholderReferenceInjector", "getReferences"));
        }
        PsiReference[] psiReferenceArray = element instanceof PsiLiteralExpression ? PlaceholderUtils.getInstance().createPlaceholderPropertiesReferences(element) : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/injector/SpringPlaceholderReferenceInjector", "getReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public String getId() {
        if ("SpringPlaceholderReference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/injector/SpringPlaceholderReferenceInjector", "getId"));
        }
        return "SpringPlaceholderReference";
    }

    @NotNull
    public String getDisplayName() {
        if ("Spring Placeholder" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/injector/SpringPlaceholderReferenceInjector", "getDisplayName"));
        }
        return "Spring Placeholder";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.SpringBean;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/injector/SpringPlaceholderReferenceInjector", "getIcon"));
        }
        return icon;
    }
}

