/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references.injector;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.spring.references.SpringBeanNamesReferenceProvider;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.util.ProcessingContext;
import icons.SpringApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SpringBeanReferenceInjector
extends ReferenceInjector {
    @NotNull
    public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull ProcessingContext context, @NotNull TextRange range) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/references/injector/SpringBeanReferenceInjector", "getReferences"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/references/injector/SpringBeanReferenceInjector", "getReferences"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spring/references/injector/SpringBeanReferenceInjector", "getReferences"));
        }
        PsiClass requiredClass = SpringBeanNamesReferenceProvider.determineRequiredClass((PsiElement)element);
        PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBeanReference(element, range, requiredClass, false)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/injector/SpringBeanReferenceInjector", "getReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public String getId() {
        if ("spring-bean-name" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/injector/SpringBeanReferenceInjector", "getId"));
        }
        return "spring-bean-name";
    }

    @NotNull
    public String getDisplayName() {
        if ("Spring Bean Name" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/injector/SpringBeanReferenceInjector", "getDisplayName"));
        }
        return "Spring Bean Name";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.SpringBean;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/injector/SpringBeanReferenceInjector", "getIcon"));
        }
        return icon;
    }
}

