/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references.injector;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.ProcessingContext;
import icons.SpringApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ResourceReferenceInjector
extends ReferenceInjector {
    @NotNull
    public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull ProcessingContext context, @NotNull TextRange range) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/references/injector/ResourceReferenceInjector", "getReferences"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/references/injector/ResourceReferenceInjector", "getReferences"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spring/references/injector/ResourceReferenceInjector", "getReferences"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        String text = element.getText();
        String s = manipulator == null ? text : manipulator.getRangeInElement(element).substring(text);
        PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getReferences(SpringResourcesBuilder.create((PsiElement)element, (String)s).fromRoot(true).fromCurrent(true));
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/injector/ResourceReferenceInjector", "getReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public String getId() {
        if ("spring-resource-reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/injector/ResourceReferenceInjector", "getId"));
        }
        return "spring-resource-reference";
    }

    @NotNull
    public String getDisplayName() {
        if ("Spring Resource Path" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/injector/ResourceReferenceInjector", "getDisplayName"));
        }
        return "Spring Resource Path";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.Spring;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/injector/ResourceReferenceInjector", "getIcon"));
        }
        return icon;
    }
}

