/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class SpringPlaceholderReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/references/SpringPlaceholderReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/references/SpringPlaceholderReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = element instanceof PsiLiteralExpression ? PlaceholderUtils.getInstance().createPlaceholderPropertiesReferences(element) : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringPlaceholderReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

