/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.refactoring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanRenameInputValidator
implements RenameInputValidatorEx {
    @Nullable
    public String getErrorMessage(@NotNull String newName, @NotNull Project project) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/spring/refactoring/SpringBeanRenameInputValidator", "getErrorMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/refactoring/SpringBeanRenameInputValidator", "getErrorMessage"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (SpringModel springModel : SpringManager.getInstance((Project)project).getAllModelsWithoutDependencies(module)) {
                SpringBeanPointer foundValue = SpringModelSearchers.findBean((CommonSpringModel)springModel, (String)newName);
                if (foundValue == null) continue;
                return "Spring Bean with name '" + newName + "' already exists in " + foundValue.getContainingFile().getName();
            }
        }
        return null;
    }

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        PsiElementPattern.Capture capture = PlatformPatterns.pomElement((ElementPattern)StandardPatterns.instanceOf(SpringBeanPsiTarget.class));
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/refactoring/SpringBeanRenameInputValidator", "getPattern"));
        }
        return capture;
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/spring/refactoring/SpringBeanRenameInputValidator", "isInputValid"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/refactoring/SpringBeanRenameInputValidator", "isInputValid"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/refactoring/SpringBeanRenameInputValidator", "isInputValid"));
        }
        return true;
    }
}

