/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.spring.perspectives.diagrams.SpringDependencyType;
import com.intellij.spring.perspectives.diagrams.SpringDiagramEdge;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanPointerWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;

public class SpringDiagramColorManager
extends DiagramColorManagerBase {
    private static final Color CUSTOM_DOM_SPRING_BEAN_HEADER_COLOR = new JBColor(new Color(192, 206, 252, 151), new Color(90, 95, 120));
    private static final Color PACKAGES_SCAN_HEADER_COLOR = new JBColor(LightColors.GREEN, JBColor.green.darker());

    public Color getEdgeColor(DiagramEdge edge) {
        if (edge instanceof SpringDiagramEdge) {
            SpringDependencyType type = ((SpringDiagramEdge)edge).getDependencyType();
            switch (type) {
                case PROPERTY_INJECTION: 
                case CONSTRUCTOR_INJECTION: 
                case LOOKUP_METHOD_INJECTION: 
                case FACTORY_BEAN: 
                case DEPENDS_ON: 
                case INNER: {
                    return DEFAULT_EDGE_COLOR;
                }
                case PARENT: {
                    return JBColor.RED.darker();
                }
                case SCANNED: {
                    return JBColor.GREEN.darker();
                }
                case AUTOWIRE: 
                case ANNO_AUTOWIRED: 
                case ANNO_RESOURCE_AUTOWIRED: 
                case ANNO_INJECT_AUTOWIRED: 
                case UNKNOWN: {
                    return JBColor.BLUE.brighter();
                }
            }
        }
        return super.getEdgeColor(edge);
    }

    public Color getNodeHeaderColor(DiagramBuilder builder, @Nullable DiagramNode node) {
        SpringBeanPointer wrapped;
        Object element;
        if (node != null && (element = node.getIdentifyingElement()) instanceof SpringBeanPointerWrapper && (wrapped = (SpringBeanPointer)((SpringBeanPointerWrapper)element).getWrapped()).isValid()) {
            if (wrapped instanceof JamSpringBeanPointer) {
                return JBColor.LIGHT_GRAY;
            }
            if (wrapped instanceof DomSpringBeanPointer) {
                CommonSpringBean bean = wrapped.getSpringBean();
                if (bean instanceof SpringBeansPackagesScanBean) {
                    return PACKAGES_SCAN_HEADER_COLOR;
                }
                if (bean instanceof DomSpringBean && !(bean instanceof SpringBean)) {
                    return CUSTOM_DOM_SPRING_BEAN_HEADER_COLOR;
                }
            }
        }
        return super.getNodeHeaderColor(builder, node);
    }
}

