/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.jee;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.jee.JndiLocated;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Required;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BeanType(provider=JndiLookupBeanTypeProvider.class)
public interface JndiLookup
extends DomSpringBean,
JndiLocated {
    @NotNull
    public GenericAttributeValue<Boolean> getCache();

    @NotNull
    public GenericAttributeValue<PsiClass> getExpectedType();

    @NotNull
    public GenericAttributeValue<Boolean> getLookupOnStartup();

    @NotNull
    public GenericAttributeValue<PsiClass> getProxyInterface();

    @Convert(value=SpringBeanResolveConverter.class)
    @NotNull
    public GenericAttributeValue<SpringBeanPointer> getDefaultRef();

    @Required(value=false)
    @NotNull
    public GenericAttributeValue<String> getDefaultValue();

    public static class JndiLookupBeanTypeProvider
    implements BeanTypeProvider<JndiLookup> {
        @NotNull
        public String[] getBeanTypeCandidates() {
            String[] stringArray = new String[]{"org.springframework.jndi.JndiObjectFactoryBean"};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/jee/JndiLookup$JndiLookupBeanTypeProvider", "getBeanTypeCandidates"));
            }
            return stringArray;
        }

        @Nullable
        public String getBeanType(JndiLookup lookup) {
            String stringValue = lookup.getExpectedType().getStringValue();
            if (!StringUtil.isEmptyOrSpaces((String)stringValue)) {
                return stringValue;
            }
            return "org.springframework.jndi.JndiObjectFactoryBean";
        }
    }
}

