/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.custom;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.xml.CustomBeanPsiElement;
import com.intellij.spring.model.xml.custom.CustomNamespaceSpringBean;
import com.intellij.util.IncorrectOperationException;
import icons.SpringApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CustomBeanFakePsiElement
extends RenameableFakePsiElement
implements CustomBeanPsiElement {
    private final CustomNamespaceSpringBean myBean;

    public CustomBeanFakePsiElement(CustomNamespaceSpringBean bean) {
        super((PsiElement)bean.getContainingFile());
        this.myBean = bean;
    }

    public XmlTag getParent() {
        return this.myBean.getXmlTag();
    }

    public String getName() {
        return this.myBean.getBeanName();
    }

    public CustomNamespaceSpringBean getBean() {
        return this.myBean;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        XmlTag xmlTag = this.getParent();
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/custom/CustomBeanFakePsiElement", "getNavigationElement"));
        }
        return xmlTag;
    }

    public String getTypeName() {
        return SpringBundle.message("spring.bean", new Object[0]);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/xml/custom/CustomBeanFakePsiElement", "setName"));
        }
        XmlAttribute idAttribute = this.myBean.getIdAttribute();
        if (idAttribute != null) {
            idAttribute.setValue(name);
        }
        return super.setName(name);
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof CustomBeanFakePsiElement) {
            CustomBeanFakePsiElement element = (CustomBeanFakePsiElement)another;
            return element.getBean().equals((Object)this.getBean());
        }
        return false;
    }

    public Icon getIcon() {
        return SpringApiIcons.SpringBean;
    }
}

