/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBaseBeanPointer;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CustomSpringBeanPointer
extends SpringBaseBeanPointer {
    private final SpringBeanPointer myBasePointer;
    private final int myIndex;

    private CustomSpringBeanPointer(@NotNull CustomBeanWrapper wrapper, CustomBean bean, int index) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/spring/model/xml/CustomSpringBeanPointer", "<init>"));
        }
        super(bean.getBeanName(), wrapper.getManager().getProject());
        this.myIndex = index;
        this.myBasePointer = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)wrapper);
    }

    @NotNull
    public CustomBean getSpringBean() {
        CustomBean customBean = (CustomBean)((CustomBeanWrapper)this.myBasePointer.getSpringBean()).getCustomBeans().get(this.myIndex);
        if (customBean == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/CustomSpringBeanPointer", "getSpringBean"));
        }
        return customBean;
    }

    public boolean isValid() {
        if (!this.myBasePointer.isValid()) {
            return false;
        }
        DomSpringBean baseBean = (DomSpringBean)this.myBasePointer.getSpringBean();
        if (!(baseBean instanceof CustomBeanWrapper)) {
            return false;
        }
        List beans = ((CustomBeanWrapper)baseBean).getCustomBeans();
        return beans.size() > this.myIndex;
    }

    @NotNull
    public static CustomSpringBeanPointer createCustomSpringBeanPointer(CustomBean bean) {
        CustomBeanWrapper wrapper = bean.getWrapper();
        int index = wrapper.getCustomBeans().indexOf(bean);
        assert (index >= 0);
        CustomSpringBeanPointer customSpringBeanPointer = new CustomSpringBeanPointer(wrapper, bean, index);
        if (customSpringBeanPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/CustomSpringBeanPointer", "createCustomSpringBeanPointer"));
        }
        return customSpringBeanPointer;
    }

    public PsiElement getPsiElement() {
        return this.getSpringBean().getIdentifyingPsiElement();
    }

    public PsiClass getBeanClass() {
        return PsiTypesUtil.getPsiClass((PsiType)this.getSpringBean().getBeanType());
    }

    public PsiFile getContainingFile() {
        return this.myBasePointer.getContainingFile();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomSpringBeanPointer)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomSpringBeanPointer that = (CustomSpringBeanPointer)o;
        if (this.myIndex != that.myIndex) {
            return false;
        }
        return !(this.myBasePointer != null ? !this.myBasePointer.equals(that.myBasePointer) : that.myBasePointer != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myBasePointer != null ? this.myBasePointer.hashCode() : 0);
        result = 31 * result + this.myIndex;
        return result;
    }
}

