/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.wrappers;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.wrappers.WModel;
import org.jetbrains.annotations.NotNull;

public class WSpringDependency {
    @NotNull
    public final String modelName;
    @NotNull
    final LocalModelDependencyType dependencyType;

    public WSpringDependency(@NotNull String name, @NotNull LocalModelDependencyType type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/wrappers/WSpringDependency", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/model/wrappers/WSpringDependency", "<init>"));
        }
        this.modelName = name;
        this.dependencyType = type;
    }

    public WSpringDependency(@NotNull Pair<LocalModel, LocalModelDependency> model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/wrappers/WSpringDependency", "<init>"));
        }
        this.dependencyType = ((LocalModelDependency)model.second).getType();
        if (model.first instanceof LocalXmlModel) {
            this.modelName = WModel.getLocalXmlModelName((LocalXmlModel)model.first);
        } else if (model.first instanceof LocalAnnotationModel) {
            this.modelName = ((PsiClass)((LocalAnnotationModel)model.first).getConfig()).getQualifiedName();
        } else {
            throw new IllegalArgumentException(String.format("Model with class:'%s' is not xml nor annotation model", model.getClass()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WSpringDependency that = (WSpringDependency)o;
        if (!this.modelName.equals(that.modelName)) {
            return false;
        }
        return this.dependencyType == that.dependencyType;
    }

    public int hashCode() {
        int result = this.modelName.hashCode();
        result = 31 * result + this.dependencyType.hashCode();
        return result;
    }
}

