/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertiesCompletionContributor;
import com.intellij.lang.properties.references.PropertiesPsiCompletionUtil;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PlaceholderPropertyCompletionContributor
extends CompletionContributor {
    public PlaceholderPropertyCompletionContributor() {
        this.extend(null, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/values/PlaceholderPropertyCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/values/PlaceholderPropertyCompletionContributor$1", "addCompletions"));
                }
                PlaceholderPropertyCompletionContributor.doAdd(parameters, result);
            }
        });
    }

    private static void doAdd(CompletionParameters parameters, CompletionResultSet result) {
        TextRange range;
        PsiElement element;
        int startOffset;
        int offsetInElement;
        PsiElement position = parameters.getPosition();
        if (!SpringCommonUtils.hasSpringFacets((Project)position.getProject())) {
            return;
        }
        Object[] references = (PsiReference[])ArrayUtil.mergeArrays((Object[])position.getReferences(), (Object[])position.getParent().getReferences());
        PlaceholderPropertyReference propertyReference = (PlaceholderPropertyReference)((Object)ContainerUtil.findInstance((Object[])references, PlaceholderPropertyReference.class));
        if (propertyReference != null && !PropertiesCompletionContributor.hasMoreImportantReference((PsiReference[])references, (PropertyReference)propertyReference) && (offsetInElement = (startOffset = parameters.getOffset()) - (element = propertyReference.getElement()).getTextRange().getStartOffset()) >= (range = propertyReference.getRangeInElement()).getStartOffset()) {
            String prefix = element.getText().substring(range.getStartOffset(), offsetInElement);
            LookupElement[] variants = PlaceholderPropertyCompletionContributor.getVariants(propertyReference);
            result.withPrefixMatcher(prefix).addAllElements(Arrays.asList(variants));
            if (variants.length != 0) {
                result.stopHere();
            }
        }
    }

    @NotNull
    private static LookupElement[] getVariants(@NotNull PlaceholderPropertyReference propertyReference) {
        if (propertyReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyReference", "com/intellij/spring/model/values/PlaceholderPropertyCompletionContributor", "getVariants"));
        }
        THashSet variants = new THashSet();
        Processor processor = arg_0 -> PlaceholderPropertyCompletionContributor.lambda$getVariants$0(propertyReference, (Set)variants, arg_0);
        CommonSpringModel springModel = SpringModelUtils.getInstance().getSpringModel(propertyReference.getElement());
        List<SpringBeanPointer> placeholders = propertyReference.getPlaceholders(springModel);
        PlaceholderPropertyReference.processXmlProperties((Processor<PropertiesFile>)processor, placeholders);
        PlaceholderPropertyReference.processEmbeddedPropertySources((Processor<PropertiesFile>)processor, springModel);
        propertyReference.processAllPropertiesIfNeed((Processor<PropertiesFile>)processor, springModel);
        for (String key : PlaceholderPropertyReference.getAllPlaceholderConfigurerProperties(placeholders).keySet()) {
            if (StringUtil.isEmptyOrSpaces((String)key)) continue;
            variants.add(key);
        }
        PlaceholderPropertyReference.processCommonModel(propertyReference.getElement().getProject(), (Processor<PropertiesFile>)processor, springModel);
        LookupElement[] lookupElementArray = PropertiesCompletionContributor.getVariants((Set)variants);
        if (lookupElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderPropertyCompletionContributor", "getVariants"));
        }
        return lookupElementArray;
    }

    private static /* synthetic */ boolean lambda$getVariants$0(@NotNull PlaceholderPropertyReference propertyReference, Set variants, PropertiesFile propertiesFile) {
        if (propertyReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyReference", "com/intellij/spring/model/values/PlaceholderPropertyCompletionContributor", "lambda$getVariants$0"));
        }
        PropertiesPsiCompletionUtil.addVariantsFromFile((PropertyReferenceBase)propertyReference, (PropertiesFile)propertiesFile, (Set)variants);
        return true;
    }
}

