/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils.search.executors;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.spring.model.xml.beans.Alias;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class XmlBeanNameQueryExecutor
extends QueryExecutorBase<SpringBeanPointer, SpringBeanSearchParameters.BeanName> {
    public static final XmlBeanNameQueryExecutor INSTANCE = new XmlBeanNameQueryExecutor();

    public void processQuery(@NotNull SpringBeanSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> consumer) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/model/utils/search/executors/XmlBeanNameQueryExecutor", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spring/model/utils/search/executors/XmlBeanNameQueryExecutor", "processQuery"));
        }
        XmlBeanNameQueryExecutor.processBeans(params, consumer, (Collection<String>)new THashSet(1));
    }

    private static boolean processBeans(@NotNull SpringBeanSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor, @NotNull Collection<String> processed) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/model/utils/search/executors/XmlBeanNameQueryExecutor", "processBeans"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/utils/search/executors/XmlBeanNameQueryExecutor", "processBeans"));
        }
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/intellij/spring/model/utils/search/executors/XmlBeanNameQueryExecutor", "processBeans"));
        }
        String beanName = params.getBeanName();
        if (processed.contains(beanName)) {
            return true;
        }
        processed.add(beanName);
        if (!SpringXmlBeansIndex.processBeansByName(params, processor)) {
            return false;
        }
        Processor aliasProcessor = alias -> {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/model/utils/search/executors/XmlBeanNameQueryExecutor", "lambda$processBeans$0"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/utils/search/executors/XmlBeanNameQueryExecutor", "lambda$processBeans$0"));
            }
            if (processed == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/intellij/spring/model/utils/search/executors/XmlBeanNameQueryExecutor", "lambda$processBeans$0"));
            }
            String aliasedBeanName = alias.getAliasedBean().getStringValue();
            return !StringUtil.isNotEmpty((String)aliasedBeanName) || XmlBeanNameQueryExecutor.processBeans(XmlBeanNameQueryExecutor.copyFrom(params, aliasedBeanName), processor, processed);
        };
        return SpringXmlBeansIndex.processAliases(params, (Processor<Alias>)aliasProcessor);
    }

    private static SpringBeanSearchParameters.BeanName copyFrom(SpringBeanSearchParameters.BeanName params, String aliasedBeanName) {
        SpringBeanSearchParameters.BeanName wrappedParams = SpringBeanSearchParameters.byName(params.getProject(), aliasedBeanName);
        wrappedParams.setSearchScope(params.getSearchScope());
        wrappedParams.setVirtualFile(params.getVirtualFile());
        return wrappedParams;
    }
}

