/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.spring.model.SpringModelSearchParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBeanSearchParameters {
    @NotNull
    private final Project myProject;
    private GlobalSearchScope myScope;
    @Nullable
    private VirtualFile myVirtualFile;

    protected SpringBeanSearchParameters(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters", "getProject"));
        }
        return project;
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.myScope == null ? GlobalSearchScope.allScope((Project)this.getProject()) : this.myScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters", "getSearchScope"));
        }
        return globalSearchScope;
    }

    public void setSearchScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters", "setSearchScope"));
        }
        this.myScope = scope;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public void setVirtualFile(@Nullable VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
    }

    public static BeanClass byClass(@NotNull Project project, @NotNull SpringModelSearchParameters.BeanClass parameters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters", "byClass"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters", "byClass"));
        }
        return new BeanClass(project, parameters);
    }

    @NotNull
    public static BeanName byName(@NotNull Project project, @NotNull String beanName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters", "byName"));
        }
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters", "byName"));
        }
        BeanName beanName2 = new BeanName(project, SpringModelSearchParameters.byName((String)beanName));
        if (beanName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters", "byName"));
        }
        return beanName2;
    }

    @NotNull
    public static BeanName byName(@NotNull Project project, @NotNull SpringModelSearchParameters.BeanName parameters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters", "byName"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters", "byName"));
        }
        BeanName beanName = new BeanName(project, parameters);
        if (beanName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters", "byName"));
        }
        return beanName;
    }

    public static class BeanName
    extends SpringBeanSearchParameters {
        @NotNull
        private final SpringModelSearchParameters.BeanName myParameters;

        private BeanName(@NotNull Project project, @NotNull SpringModelSearchParameters.BeanName parameters) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters$BeanName", "<init>"));
            }
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters$BeanName", "<init>"));
            }
            super(project);
            this.myParameters = parameters;
        }

        @NotNull
        public String getBeanName() {
            String string = this.myParameters.getBeanName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters$BeanName", "getBeanName"));
            }
            return string;
        }
    }

    public static class BeanClass
    extends SpringBeanSearchParameters {
        @NotNull
        private final SpringModelSearchParameters.BeanClass myParameters;

        private BeanClass(@NotNull Project project, @NotNull SpringModelSearchParameters.BeanClass parameters) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters$BeanClass", "<init>"));
            }
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters$BeanClass", "<init>"));
            }
            super(project);
            this.myParameters = parameters;
        }

        public boolean matchesClass(@Nullable PsiType psiType) {
            if (psiType == null || !psiType.isValid() || TypeConversionUtil.isNullType((PsiType)psiType)) {
                return false;
            }
            return this.getPsiType().isAssignableFrom(psiType);
        }

        @NotNull
        public PsiType getPsiType() {
            PsiType psiType = this.myParameters.getSearchType();
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/search/SpringBeanSearchParameters$BeanClass", "getPsiType"));
            }
            return psiType;
        }

        public boolean isWithInheritors() {
            return this.myParameters.isWithInheritors();
        }

        public boolean isEffectiveBeanTypes() {
            return this.myParameters.isEffectiveBeanTypes();
        }
    }
}

