/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementsNavigationManager;
import com.intellij.util.xml.GenericDomValue;
import icons.SpringApiIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringInjectionTreeElement
implements StructureViewTreeElement,
ItemPresentation {
    private final SpringValueHolderDefinition myInjection;
    @NonNls
    private static final String CONSTRUCTOR_ARG = "constructor-arg";
    @NonNls
    private static final String PROPERTY_TAG = "property";

    public SpringInjectionTreeElement(@NotNull SpringValueHolderDefinition injection) {
        if (injection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injection", "com/intellij/spring/model/structure/SpringInjectionTreeElement", "<init>"));
        }
        this.myInjection = injection;
    }

    public Object getValue() {
        return this.myInjection.getXmlElement();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        SpringInjectionTreeElement springInjectionTreeElement = this;
        if (springInjectionTreeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/structure/SpringInjectionTreeElement", "getPresentation"));
        }
        return springInjectionTreeElement;
    }

    public String getPresentableText() {
        PsiType type;
        if (this.isConstructorArg()) {
            return CONSTRUCTOR_ARG;
        }
        SpringProperty springProperty = (SpringProperty)this.myInjection;
        String propertyName = springProperty.getName().getStringValue();
        if (propertyName == null) {
            propertyName = PROPERTY_TAG;
        }
        if ((type = SpringInjectionTreeElement.getPropertyType(springProperty)) != null) {
            propertyName = propertyName + ": " + type.getCanonicalText();
        }
        return propertyName;
    }

    @Nullable
    private static PsiType getPropertyType(SpringProperty property) {
        List value = (List)property.getName().getValue();
        if (value != null && !value.isEmpty()) {
            return ((BeanProperty)value.get(0)).getPropertyType();
        }
        return property.guessTypeByValue();
    }

    public String getLocationString() {
        String value = this.getValueText();
        if (value != null) {
            return "value=\"" + value + "\"";
        }
        value = this.getRefText();
        if (value != null) {
            return "ref=\"" + value + "\"";
        }
        return null;
    }

    public Icon getIcon(boolean open) {
        return this.isConstructorArg() ? AllIcons.Nodes.Method : SpringApiIcons.SpringProperty;
    }

    @NotNull
    public TreeElement[] getChildren() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/structure/SpringInjectionTreeElement", "getChildren"));
        }
        return EMPTY_ARRAY;
    }

    public void navigate(boolean requestFocus) {
        DomElementNavigationProvider navigationProvider = DomElementsNavigationManager.getManager((Project)this.myInjection.getManager().getProject()).getDomElementsNavigateProvider(DomElementsNavigationManager.DEFAULT_PROVIDER_NAME);
        navigationProvider.navigate((DomElement)this.myInjection, requestFocus);
    }

    public boolean canNavigate() {
        return this.myInjection.isValid();
    }

    public boolean canNavigateToSource() {
        return this.myInjection.isValid();
    }

    public boolean isConstructorArg() {
        return this.myInjection instanceof ConstructorArg;
    }

    @Nullable
    private String getValueText() {
        return this.myInjection.getValueAsString();
    }

    @Nullable
    private String getRefText() {
        GenericDomValue refElement = this.myInjection.getRefElement();
        return refElement != null ? refElement.getStringValue() : null;
    }
}

