/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.scope;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringManager;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.scope.SpringBeanScopeManager;
import com.intellij.spring.model.scope.SpringCustomBeanScope;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class SpringBeanScopeManagerImpl
extends SpringBeanScopeManager {
    public List<SpringBeanScope> getCustomBeanScopes(@Nullable PsiElement element) {
        SpringCustomBeanScope customBeanScope;
        PsiClass scopeClass;
        if (element == null || DumbService.isDumb((Project)element.getProject())) {
            return Collections.emptyList();
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return Collections.emptyList();
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiFile containingFile = element.getContainingFile();
        Set models = SpringManager.getInstance((Project)element.getProject()).getSpringModelsByFile(containingFile);
        SmartList customScopes = new SmartList();
        SpringCustomBeanScope[] springCustomBeanScopeArray = (SpringCustomBeanScope[])SpringCustomBeanScope.EP_NAME.getExtensions();
        int n = springCustomBeanScopeArray.length;
        for (int i = 0; i < n && ((scopeClass = javaPsiFacade.findClass((customBeanScope = springCustomBeanScopeArray[i]).getScopeClassName(), searchScope)) == null || customBeanScope.process((List)customScopes, models, scopeClass, element)); ++i) {
        }
        return customScopes;
    }
}

