/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringContextIncludeRegexFilter
extends SpringContextFilter.IncludeExpression {
    public SpringContextIncludeRegexFilter(@Nullable String expression) {
        super(expression);
    }

    @NotNull
    public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "includeStereotypes"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "includeStereotypes"));
        }
        LinkedHashSet components = ContainerUtil.newLinkedHashSet();
        String regexp = this.getExpression();
        if (!StringUtil.isEmptyOrSpaces((String)regexp)) {
            try {
                Pattern pattern = Pattern.compile(regexp);
                GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                for (PsiClass annotatedClass : SpringContextIncludeRegexFilter.findClassesByMask(searchScope, pattern, packages)) {
                    components.add(new CustomSpringComponent(annotatedClass));
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        LinkedHashSet linkedHashSet = components;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "includeStereotypes"));
        }
        return linkedHashSet;
    }

    private static Set<PsiClass> findClassesByMask(GlobalSearchScope searchScope, @NotNull Pattern pattern, @NotNull Set<PsiPackage> packages) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        LinkedHashSet classes = ContainerUtil.newLinkedHashSet();
        for (PsiPackage psiPackage : packages) {
            SpringContextIncludeRegexFilter.findClassesByMask(searchScope, pattern, classes, psiPackage);
        }
        return classes;
    }

    private static void findClassesByMask(@NotNull GlobalSearchScope searchScope, @NotNull Pattern pattern, @NotNull Set<PsiClass> classes, @NotNull PsiPackage psiPackage) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        for (PsiClass psiClass : psiPackage.getClasses(searchScope)) {
            String fqn = psiClass.getQualifiedName();
            if (fqn == null || !pattern.matcher(fqn).matches()) continue;
            classes.add(psiClass);
        }
        for (PsiClass psiClass : psiPackage.getSubPackages(searchScope)) {
            SpringContextIncludeRegexFilter.findClassesByMask(searchScope, pattern, classes, (PsiPackage)psiClass);
        }
    }
}

