/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.testContexts.SpringTestingModel;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringTestContextUtilImpl
extends SpringTestContextUtil {
    public static final String CONTEXT_CONFIGURATION_SUFFIX = "ContextConfiguration";

    public boolean isTestContextConfigurationClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/testContexts/SpringTestContextUtilImpl", "isTestContextConfigurationClass"));
        }
        if (psiClass.isAnnotationType() || psiClass.isEnum()) {
            return false;
        }
        PsiFile containingFile = psiClass.getContainingFile().getOriginalFile();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiClass.getProject()).getFileIndex();
        if (!projectFileIndex.isInTestSourceContent(virtualFile)) {
            return false;
        }
        CommonProcessors.FindFirstProcessor<PsiClass> findFirstProcessor = new CommonProcessors.FindFirstProcessor<PsiClass>(){

            protected boolean accept(PsiClass psiClass) {
                return SpringTestContextUtilImpl.isSpringContextConfiguration(psiClass);
            }
        };
        InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)true, (Processor)findFirstProcessor);
        return findFirstProcessor.isFound();
    }

    private static boolean isSpringContextConfiguration(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/testContexts/SpringTestContextUtilImpl", "isSpringContextConfiguration"));
        }
        JamService service = JamService.getJamService((Project)psiClass.getProject());
        return service.getJamElement(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, (PsiElement)psiClass) != null || service.getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringContextHierarchy.META}) != null;
    }

    @NotNull
    public CommonSpringModel getSpringTestingModel(@NotNull PsiClass testClass) {
        if (testClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testClass", "com/intellij/spring/model/jam/testContexts/SpringTestContextUtilImpl", "getSpringTestingModel"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)testClass);
        Object object = module == null ? SpringModel.UNKNOWN : new SpringTestingModel(testClass, module);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestContextUtilImpl", "getSpringTestingModel"));
        }
        return object;
    }

    public void discoverConfigFiles(@NotNull ContextConfiguration contextConfiguration, @NotNull Set<XmlFile> appContexts, @NotNull Set<PsiClass> configurationContexts, PsiClass ... contexts) {
        if (contextConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextConfiguration", "com/intellij/spring/model/jam/testContexts/SpringTestContextUtilImpl", "discoverConfigFiles"));
        }
        if (appContexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appContexts", "com/intellij/spring/model/jam/testContexts/SpringTestContextUtilImpl", "discoverConfigFiles"));
        }
        if (configurationContexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationContexts", "com/intellij/spring/model/jam/testContexts/SpringTestContextUtilImpl", "discoverConfigFiles"));
        }
        if (!contextConfiguration.hasLocationsAttribute() && !contextConfiguration.hasValueAttribute()) {
            XmlFile xmlFile = SpringTestContextUtilImpl.getDefaultLocation(contextConfiguration);
            if (xmlFile != null && SpringDomUtils.isSpringXml((XmlFile)xmlFile)) {
                appContexts.add(xmlFile);
            }
        } else {
            for (XmlFile xmlFile : contextConfiguration.getLocations(contexts)) {
                if (!SpringDomUtils.isSpringXml((XmlFile)xmlFile)) continue;
                appContexts.add(xmlFile);
            }
        }
        if (!contextConfiguration.hasLocationsAttribute() && !contextConfiguration.hasValueAttribute() && contextConfiguration.getConfigurationClasses().isEmpty()) {
            PsiClass configuration = SpringTestContextUtilImpl.getDefaultConfiguration(contextConfiguration);
            if (configuration != null) {
                configurationContexts.add(configuration);
            }
        } else {
            configurationContexts.addAll(contextConfiguration.getConfigurationClasses());
        }
    }

    @Nullable
    static XmlFile getDefaultLocation(@NotNull ContextConfiguration contextConfiguration) {
        if (contextConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextConfiguration", "com/intellij/spring/model/jam/testContexts/SpringTestContextUtilImpl", "getDefaultLocation"));
        }
        if (!SpringTestContextUtilImpl.isAnnotationConfigLoader(contextConfiguration)) {
            PsiClass psiClass = contextConfiguration.getPsiElement();
            String defaultAppContextName = SpringTestContextUtilImpl.getDefaultAppContextName(contextConfiguration);
            PsiDirectory containingDirectory = psiClass.getContainingFile().getContainingDirectory();
            if (containingDirectory != null) {
                PsiFile file = containingDirectory.findFile(defaultAppContextName);
                if (file instanceof XmlFile) {
                    return (XmlFile)file;
                }
                PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory);
                if (psiPackage != null) {
                    for (PsiDirectory psiDirectory : psiPackage.getDirectories()) {
                        file = psiDirectory.findFile(defaultAppContextName);
                        if (!(file instanceof XmlFile)) continue;
                        return (XmlFile)file;
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    static PsiClass getDefaultConfiguration(@NotNull ContextConfiguration contextConfiguration) {
        PsiClass psiClass;
        PsiDirectory containingDirectory;
        if (contextConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextConfiguration", "com/intellij/spring/model/jam/testContexts/SpringTestContextUtilImpl", "getDefaultConfiguration"));
        }
        if (SpringTestContextUtilImpl.isAnnotationConfigLoader(contextConfiguration) && (containingDirectory = (psiClass = contextConfiguration.getPsiElement()).getContainingFile().getContainingDirectory()) != null) {
            String[] defaultAppContextName;
            for (String s : defaultAppContextName = SpringTestContextUtilImpl.getDefaultConfigurationNames(contextConfiguration)) {
                PsiClass defaultConfiguration = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(s, psiClass.getResolveScope());
                if (defaultConfiguration == null) continue;
                return defaultConfiguration;
            }
        }
        return null;
    }

    static String getDefaultAppContextName(@NotNull ContextConfiguration contextConfiguration) {
        if (contextConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextConfiguration", "com/intellij/spring/model/jam/testContexts/SpringTestContextUtilImpl", "getDefaultAppContextName"));
        }
        String suffix = "-context.xml";
        return contextConfiguration.getPsiElement().getName() + "-context.xml";
    }

    private static String[] getDefaultConfigurationNames(@NotNull ContextConfiguration contextConfiguration) {
        if (contextConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextConfiguration", "com/intellij/spring/model/jam/testContexts/SpringTestContextUtilImpl", "getDefaultConfigurationNames"));
        }
        String name = contextConfiguration.getPsiElement().getQualifiedName();
        return new String[]{name + CONTEXT_CONFIGURATION_SUFFIX, name + "." + CONTEXT_CONFIGURATION_SUFFIX};
    }

    static boolean isGenericXmlContextLoader(SpringContextConfiguration contextConfiguration) {
        return SpringTestContextUtilImpl.isConfigClassLoader((ContextConfiguration)contextConfiguration, "org.springframework.test.context.support.GenericXmlContextLoader");
    }

    static boolean isAnnotationConfigLoader(ContextConfiguration contextConfiguration) {
        return SpringTestContextUtilImpl.isConfigClassLoader(contextConfiguration, "org.springframework.test.context.support.AnnotationConfigContextLoader");
    }

    private static boolean isConfigClassLoader(ContextConfiguration contextConfiguration, String className) {
        PsiClass psiClass = contextConfiguration.getLoaderClass();
        if (psiClass == null) {
            return false;
        }
        return className.equals(psiClass.getQualifiedName()) || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)className);
    }
}

