/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.javaConfig;

import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomDescriptionProvider;
import com.intellij.pom.PomTarget;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.pom.SpringBeanPomTargetUtils;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import org.jetbrains.annotations.NotNull;

public class SpringPomTargetDescriptionProvider
extends PomDescriptionProvider {
    public String getElementDescription(@NotNull PomTarget element, @NotNull ElementDescriptionLocation location) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/jam/javaConfig/SpringPomTargetDescriptionProvider", "getElementDescription"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/spring/model/jam/javaConfig/SpringPomTargetDescriptionProvider", "getElementDescription"));
        }
        CommonSpringBean springBean = SpringBeanPomTargetUtils.getSpringBean((PomTarget)element);
        if (springBean == null) {
            return null;
        }
        if (location == UsageViewTypeLocation.INSTANCE) {
            return SpringPomTargetDescriptionProvider.getSpringBeanTypeName(springBean);
        }
        if (location == UsageViewNodeTextLocation.INSTANCE || location == HighlightUsagesDescriptionLocation.INSTANCE) {
            return SpringPomTargetDescriptionProvider.getSpringBeanTypeName(springBean) + " " + springBean.getBeanName();
        }
        return null;
    }

    private static String getSpringBeanTypeName(CommonSpringBean springBean) {
        return StringUtil.notNullize((String)TypePresentationService.getService().getTypeName((Object)springBean), (String)SpringBundle.message("spring.bean", new Object[0]));
    }
}

