/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.jam.SpringAutowiredBeanFindUsagesHandler;
import com.intellij.spring.model.jam.javaConfig.SpringJavaExternalBean;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringJavaBeanReferencesFindUsagesHandler
extends FindUsagesHandler {
    private final CommonSpringBean mySpringBean;
    private final SpringBeanPointer myPointer;

    public SpringJavaBeanReferencesFindUsagesHandler(CommonSpringBean springBean) {
        super(springBean.getIdentifyingPsiElement());
        this.mySpringBean = springBean;
        this.myPointer = BeanService.getInstance().createSpringBeanPointer(this.mySpringBean);
    }

    @NotNull
    public PsiElement[] getSecondaryElements() {
        List list = SpringOldJavaConfigurationUtil.findExternalBeanReferences((CommonSpringBean)this.mySpringBean);
        HashSet<PsiMethod> psiElements = new HashSet<PsiMethod>();
        for (SpringJavaExternalBean externalBean : list) {
            PsiMethod method = externalBean.getPsiElement();
            psiElements.add(method);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(psiElements);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/jam/SpringJavaBeanReferencesFindUsagesHandler", "getSecondaryElements"));
        }
        return psiElementArray;
    }

    public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<UsageInfo> processor, @NotNull FindUsagesOptions options) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/highlighting/jam/SpringJavaBeanReferencesFindUsagesHandler", "processElementUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/highlighting/jam/SpringJavaBeanReferencesFindUsagesHandler", "processElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/spring/model/highlighting/jam/SpringJavaBeanReferencesFindUsagesHandler", "processElementUsages"));
        }
        return super.processElementUsages(element, processor, options) && SpringAutowiredBeanFindUsagesHandler.processAutowiredBeans(element, processor, options, this.myPointer);
    }
}

