/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.config;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import org.jetbrains.annotations.NotNull;

class CreateSpringFacetFix
implements LocalQuickFix {
    private final Module myModule;

    CreateSpringFacetFix(Module module) {
        this.myModule = module;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpringBundle.message("spring.facet.inspection.create.facet", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/config/CreateSpringFacetFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/config/CreateSpringFacetFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/config/CreateSpringFacetFix", "applyFix"));
        }
        UsageTrigger.trigger((String)"spring.SpringFacetInspection.AddFacetFix");
        SpringFacet springFacet = (SpringFacet)FacetManager.getInstance((Module)this.myModule).addFacet(SpringFacet.getSpringFacetType(), "Spring", null);
        DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ModulesConfigurator.showFacetSettingsDialog((Facet)springFacet, null);
        }
    }
}

