/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringInspectionsRegistry;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringValidator
extends InspectionValidator {
    public SpringValidator() {
        super(SpringApiBundle.message((String)"model.inspection.validator.description.text", (Object[])new Object[0]), SpringBundle.message("model.inspection.validator.progress.text", new Object[0]));
    }

    private static boolean isAvailableOnModule(Module module) {
        return SpringCommonUtils.hasSpringFacet((Module)module);
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        Class[] classArray = SpringInspectionsRegistry.getInstance().getSpringInspectionClasses();
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringValidator", "getInspectionToolClasses"));
        }
        return classArray;
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/highlighting/SpringValidator", "isAvailableOnScope"));
        }
        for (Module module : scope.getAffectedModules()) {
            if (!SpringValidator.isAvailableOnModule(module)) continue;
            return true;
        }
        return false;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        LinkedHashSet files = ContainerUtil.newLinkedHashSet();
        for (Module module : context.getCompileScope().getAffectedModules()) {
            Set models = SpringManager.getInstance((Project)project).getAllModels(module);
            for (SpringModel model : models) {
                for (PsiFile configFile : model.getConfigFiles()) {
                    VirtualFile file = configFile.getVirtualFile();
                    ContainerUtil.addIfNotNull((Collection)files, (Object)file);
                }
            }
        }
        for (Module module : SpringValidator.getAdditionalFilesContributors()) {
            files.addAll(module.getAdditionalFilesToProcess(project, context));
        }
        InspectionValidatorUtil.expandCompileScopeIfNeeded((Collection)files, (CompileContext)context);
        return files;
    }

    @NotNull
    public Map<ProblemDescriptor, HighlightDisplayLevel> checkAdditionally(PsiFile topFile) {
        LinkedHashMap additionalHighlighting = ContainerUtil.newLinkedHashMap();
        for (SpringInspectionsRegistry.AdditionalFilesContributor contributor : SpringValidator.getAdditionalFilesContributors()) {
            additionalHighlighting.putAll(contributor.checkAdditionally(topFile));
        }
        LinkedHashMap linkedHashMap = additionalHighlighting;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringValidator", "checkAdditionally"));
        }
        return linkedHashMap;
    }

    @NotNull
    private static SpringInspectionsRegistry.AdditionalFilesContributor[] getAdditionalFilesContributors() {
        SpringInspectionsRegistry.AdditionalFilesContributor[] additionalFilesContributorArray = (SpringInspectionsRegistry.AdditionalFilesContributor[])SpringInspectionsRegistry.AdditionalFilesContributor.EP_NAME.getExtensions();
        if (additionalFilesContributorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringValidator", "getAdditionalFilesContributors"));
        }
        return additionalFilesContributorArray;
    }
}

