/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.values.converters.resources.ResourceTypeCondition;
import com.intellij.spring.model.values.converters.resources.SpringResourceTypeProvider;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringIncorrectResourceTypeInspection
extends BasicDomElementsInspection<Beans> {
    private static final GenericValueReferenceProvider ourProvider = new GenericValueReferenceProvider();

    public SpringIncorrectResourceTypeInspection() {
        super(Beans.class, new Class[0]);
    }

    protected boolean shouldCheckResolveProblems(GenericDomValue value) {
        return false;
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (element instanceof GenericDomValue) {
            PsiReference[] references;
            GenericDomValue value = (GenericDomValue)element;
            XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)value);
            if (valueElement == null) {
                return;
            }
            Condition<PsiFileSystemItem> filter = SpringIncorrectResourceTypeInspection.findCondition(value);
            if (filter == null) {
                return;
            }
            for (PsiReference reference : references = ourProvider.getReferencesByElement((PsiElement)valueElement, new ProcessingContext())) {
                PsiFileSystemItem psiFileSystemItem;
                if (!(reference instanceof FileReference) || (psiFileSystemItem = ((FileReference)reference).resolve()) == null || psiFileSystemItem.isDirectory() || filter.value((Object)psiFileSystemItem)) continue;
                String expectedExtensions = null;
                if (filter instanceof ResourceTypeCondition) {
                    expectedExtensions = StringUtil.join((String[])((ResourceTypeCondition)filter).getExpectedExtensions(), (String)",");
                }
                holder.createProblem(element, expectedExtensions == null ? SpringBundle.message("SpringIncorrectResourceTypeInspection.incorrect.resource.type", new Object[0]) : SpringBundle.message("SpringIncorrectResourceTypeInspection.expected.resource.types", expectedExtensions), new LocalQuickFix[0]);
            }
        }
    }

    @Nullable
    private static Condition<PsiFileSystemItem> findCondition(GenericDomValue value) {
        for (SpringResourceTypeProvider provider : (SpringResourceTypeProvider[])Extensions.getExtensions((ExtensionPointName)SpringResourceTypeProvider.EP_NAME)) {
            Condition filter = provider.getResourceFilter(value);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringIncorrectResourceTypeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringIncorrectResourceTypeInspection", "getShortName"));
        }
        return "SpringIncorrectResourceTypeInspection";
    }
}

