/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringInactiveProfileHighlightingInspection
extends DomElementsInspection<Beans> {
    public SpringInactiveProfileHighlightingInspection() {
        super(Beans.class, new Class[0]);
    }

    @Nullable
    protected ProblemDescriptor[] checkDomFile(@NotNull DomFileElement<Beans> domFileElement, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (domFileElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domFileElement", "com/intellij/spring/model/highlighting/SpringInactiveProfileHighlightingInspection", "checkDomFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/highlighting/SpringInactiveProfileHighlightingInspection", "checkDomFile"));
        }
        HashSet descriptors = new HashSet();
        XmlFile xmlFile = domFileElement.getFile();
        Beans beans = (Beans)domFileElement.getRootElement();
        SpringModel springModel = SpringManager.getInstance((Project)xmlFile.getProject()).getSpringModelByFile((PsiFile)xmlFile);
        if (springModel != null) {
            Set activeProfiles = springModel.getActiveProfiles();
            if (SpringProfileUtils.isActiveProfile((Beans)beans, (Set)activeProfiles)) {
                for (Beans innerBeans : beans.getBeansProfiles()) {
                    if (SpringProfileUtils.isActiveProfile((Beans)innerBeans, (Set)activeProfiles)) continue;
                    descriptors.add(this.createProblem(manager, innerBeans, springModel));
                }
            } else {
                descriptors.add(this.createProblem(manager, beans, springModel));
            }
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    @NotNull
    public ProblemDescriptor createProblem(@NotNull InspectionManager manager, @NotNull Beans beans, @NotNull SpringModel springModel) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/highlighting/SpringInactiveProfileHighlightingInspection", "createProblem"));
        }
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/SpringInactiveProfileHighlightingInspection", "createProblem"));
        }
        if (springModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springModel", "com/intellij/spring/model/highlighting/SpringInactiveProfileHighlightingInspection", "createProblem"));
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)beans.getXmlTag(), SpringBundle.message("SpringInactiveProfilesHighlightingPass.inactive.profile", new Object[0]), true, this.getFixes(beans.getProfile().getNames(), springModel.getFileSet()), ProblemHighlightType.LIKE_UNUSED_SYMBOL);
        if (problemDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringInactiveProfileHighlightingInspection", "createProblem"));
        }
        return problemDescriptor;
    }

    public LocalQuickFix[] getFixes(@NotNull Set<String> names, @Nullable SpringFileSet set) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/spring/model/highlighting/SpringInactiveProfileHighlightingInspection", "getFixes"));
        }
        HashSet fixes = new HashSet();
        if (set != null) {
            for (String name : names) {
                fixes.add(new MyLocalQuickFix(name, set));
            }
        }
        return fixes.toArray(new LocalQuickFix[fixes.size()]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringInactiveProfileHighlightingInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringInactiveProfileHighlightingInspection", "getShortName"));
        }
        return "SpringInactiveProfileHighlightingInspection";
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private final String myProfileName;
        private final SpringFileSet myFileSet;

        public MyLocalQuickFix(String name, SpringFileSet set) {
            this.myProfileName = name;
            this.myFileSet = set;
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("ActivateSpringProfileIntentionAction.activate.profile", this.myProfileName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringInactiveProfileHighlightingInspection$MyLocalQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("ActivateSpringProfileIntentionAction.activate.profile.family.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringInactiveProfileHighlightingInspection$MyLocalQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/SpringInactiveProfileHighlightingInspection$MyLocalQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/SpringInactiveProfileHighlightingInspection$MyLocalQuickFix", "applyFix"));
            }
            Set activeProfiles = this.myFileSet.getActiveProfiles();
            activeProfiles.add(this.myProfileName);
            this.myFileSet.setActiveProfiles(activeProfiles);
            SpringModificationTrackersManager.getInstance((Project)project).fireActiveProfilesChanged();
            ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker()).incCounter();
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
            UsageTrigger.trigger((String)"spring.SpringInactiveProfilesAnnotator.activateProfile");
        }
    }
}

