/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.Idref;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringMap;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractBeanReferencesInspection
extends SpringBeanInspectionBase {
    protected void checkBean(SpringBean springBean, Beans beans, DomElementAnnotationHolder holder, XmlSpringModel springModel) {
        for (SpringValueHolderDefinition property : SpringPropertyUtils.getValueHolders((CommonSpringBean)springBean)) {
            AbstractBeanReferencesInspection.checkAbstractBeanReferences(property, holder);
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("AbstractBeanReferencesInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/AbstractBeanReferencesInspection", "getShortName"));
        }
        return "AbstractBeanReferencesInspection";
    }

    private static void checkAbstractBeanReferences(SpringValueHolderDefinition definition, DomElementAnnotationHolder holder) {
        SpringBeanPointer ref;
        GenericDomValue refElement = definition.getRefElement();
        if (refElement != null && (ref = (SpringBeanPointer)refElement.getValue()) != null) {
            AbstractBeanReferencesInspection.checkNotAbstract((DomElement)refElement, ref, holder);
        }
        if (definition instanceof SpringValueHolder) {
            SpringValueHolder springInjection = (SpringValueHolder)definition;
            AbstractBeanReferencesInspection.checkSpringRefBeans(springInjection.getRef(), holder);
            if (DomUtil.hasXml((DomElement)springInjection.getBean())) {
                SpringBean innerBean = springInjection.getBean();
                AbstractBeanReferencesInspection.checkNotAbstract((DomElement)innerBean, BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)innerBean), holder);
            }
            AbstractBeanReferencesInspection.checkIdrefBeans(springInjection.getIdref(), holder);
            if (DomUtil.hasXml((DomElement)springInjection.getList())) {
                AbstractBeanReferencesInspection.checkCollectionReferences((CollectionElements)springInjection.getList(), holder);
            }
            if (DomUtil.hasXml((DomElement)springInjection.getSet())) {
                AbstractBeanReferencesInspection.checkCollectionReferences((CollectionElements)springInjection.getSet(), holder);
            }
            if (DomUtil.hasXml((DomElement)springInjection.getArray())) {
                AbstractBeanReferencesInspection.checkCollectionReferences((CollectionElements)springInjection.getArray(), holder);
            }
            if (DomUtil.hasXml((DomElement)springInjection.getMap())) {
                AbstractBeanReferencesInspection.checkMapReferences(springInjection.getMap(), holder);
            }
        }
    }

    private static void checkNotAbstract(DomElement annotated, @Nullable SpringBeanPointer springBean, DomElementAnnotationHolder holder) {
        if (springBean != null && springBean.isAbstract()) {
            holder.createProblem(annotated, SpringBundle.message("spring.bean.referenced.by.abstract.bean", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkMapReferences(SpringMap map, DomElementAnnotationHolder beans) {
        for (SpringEntry entry : map.getEntries()) {
            AbstractBeanReferencesInspection.checkAbstractBeanReferences((SpringValueHolderDefinition)entry, beans);
        }
    }

    private static void checkIdrefBeans(Idref idref, DomElementAnnotationHolder holder) {
        GenericAttributeValue bean;
        if (!DomUtil.hasXml((DomElement)idref)) {
            return;
        }
        GenericAttributeValue local = idref.getLocal();
        if (DomUtil.hasXml((DomElement)local)) {
            AbstractBeanReferencesInspection.checkNotAbstract((DomElement)local, (SpringBeanPointer)local.getValue(), holder);
        }
        if (DomUtil.hasXml((DomElement)(bean = idref.getBean()))) {
            AbstractBeanReferencesInspection.checkNotAbstract((DomElement)bean, (SpringBeanPointer)bean.getValue(), holder);
        }
    }

    private static void checkSpringRefBeans(SpringRef springRef, DomElementAnnotationHolder holder) {
        if (DomUtil.hasXml((DomElement)springRef)) {
            GenericAttributeValue local;
            GenericAttributeValue bean = springRef.getBean();
            if (DomUtil.hasXml((DomElement)bean)) {
                AbstractBeanReferencesInspection.checkNotAbstract((DomElement)bean, (SpringBeanPointer)bean.getValue(), holder);
            }
            if (DomUtil.hasXml((DomElement)(local = springRef.getLocal()))) {
                AbstractBeanReferencesInspection.checkNotAbstract((DomElement)local, (SpringBeanPointer)local.getValue(), holder);
            }
        }
    }

    private static void checkCollectionReferences(CollectionElements elements, DomElementAnnotationHolder holder) {
        for (SpringRef springRef : elements.getRefs()) {
            AbstractBeanReferencesInspection.checkSpringRefBeans(springRef, holder);
        }
        for (Idref idref : elements.getIdrefs()) {
            AbstractBeanReferencesInspection.checkIdrefBeans(idref, holder);
        }
        for (ListOrSet listOrSet : elements.getLists()) {
            AbstractBeanReferencesInspection.checkCollectionReferences((CollectionElements)listOrSet, holder);
        }
        for (ListOrSet listOrSet : elements.getSets()) {
            AbstractBeanReferencesInspection.checkCollectionReferences((CollectionElements)listOrSet, holder);
        }
        for (ListOrSet listOrSet : elements.getArrays()) {
            AbstractBeanReferencesInspection.checkCollectionReferences((CollectionElements)listOrSet, holder);
        }
        for (SpringBean innerBean : elements.getBeans()) {
            AbstractBeanReferencesInspection.checkNotAbstract((DomElement)innerBean, BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)innerBean), holder);
        }
        for (SpringMap map : elements.getMaps()) {
            AbstractBeanReferencesInspection.checkMapReferences(map, holder);
        }
    }
}

