/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.events.jam;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.events.beans.PublishEventPointDescriptor;
import com.intellij.spring.model.events.jam.CustomSpringEventListener;
import com.intellij.spring.model.events.jam.SpringEventListener;
import com.intellij.spring.model.events.jam.SpringJamEventListener;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringEventModelUtils {
    private static final String PUBLISH_EVENT_METHOD = "publishEvent";

    @NotNull
    public static List<SpringEventListener> getEventListeners(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        LinkedList result = ContainerUtil.newLinkedList();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JamService service = JamService.getJamService((Project)module.getProject());
        result.addAll(service.getJamMethodElements(SpringJamEventListener.SEM_KEY, "org.springframework.context.event.EventListener", scope));
        List customAnnos = ContainerUtil.mapNotNull((Collection)JamAnnotationTypeUtil.getInstance((Module)module).getAnnotationTypesWithChildren("org.springframework.context.event.EventListener"), PsiClass::getQualifiedName);
        for (String customAnno : customAnnos) {
            result.addAll(service.getJamMethodElements(CustomSpringEventListener.JAM_KEY, customAnno, scope));
        }
        LinkedList linkedList = result;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        return linkedList;
    }

    @NotNull
    public static Collection<PublishEventPointDescriptor> getPublishPoints(@NotNull Module module, @NotNull PsiType handledType) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        if (handledType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handledType", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        List<PublishEventPointDescriptor> list = SpringEventModelUtils.filter(SpringEventModelUtils.getPublishPoints(module), handledType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        return list;
    }

    @NotNull
    public static Set<PublishEventPointDescriptor> getPublishPoints(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        LinkedHashSet descriptors = ContainerUtil.newLinkedHashSet();
        for (PsiMethod publishEventMethod : SpringEventModelUtils.getPublishEventMethods(module.getProject())) {
            descriptors.addAll(SpringEventModelUtils.searchAndCachePublishPoints(publishEventMethod, (SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)));
        }
        descriptors.addAll(SpringEventModelUtils.searchEventListenerDescriptors(module));
        LinkedHashSet linkedHashSet = descriptors;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        return linkedHashSet;
    }

    public static List<PublishEventPointDescriptor> filter(@NotNull Set<PublishEventPointDescriptor> allDescriptors, @NotNull PsiType eventType) {
        if (allDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDescriptors", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "filter"));
        }
        if (eventType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "filter"));
        }
        return ContainerUtil.filter(allDescriptors, descriptor -> {
            if (eventType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "lambda$filter$0"));
            }
            PsiType publishType = descriptor.getEventType();
            return publishType != null && eventType.isAssignableFrom(publishType);
        });
    }

    @NotNull
    public static List<SpringEventListener> getEventListeners(@NotNull Module module, @NotNull PsiType publishType) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        if (publishType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishType", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        List list = ContainerUtil.filter(SpringEventModelUtils.getEventListeners(module), listener -> {
            if (publishType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishType", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "lambda$getEventListeners$1"));
            }
            for (PsiType eventType : SpringEventModelUtils.getEventListenerHandledType(listener)) {
                if (!eventType.isAssignableFrom(publishType)) continue;
                return true;
            }
            return false;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        return list;
    }

    @NotNull
    public static Set<PublishEventPointDescriptor> searchEventListenerDescriptors(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchEventListenerDescriptors"));
        }
        HashSet descriptors = ContainerUtil.newHashSet();
        for (SpringEventListener listener : SpringEventModelUtils.getEventListeners(module)) {
            PsiMethod psiMethod = listener.getPsiElement();
            PsiType returnType = psiMethod.getReturnType();
            if (returnType == null || PsiType.VOID.equals((Object)returnType)) continue;
            descriptors.add(PublishEventPointDescriptor.create(psiMethod));
        }
        HashSet hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchEventListenerDescriptors"));
        }
        return hashSet;
    }

    public static PsiMethod[] getPublishEventMethods(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishEventMethods"));
        }
        PsiClass eventPublisherClass = SpringEventModelUtils.findApplicationEventPublisher(project);
        if (eventPublisherClass != null) {
            return eventPublisherClass.findMethodsByName(PUBLISH_EVENT_METHOD, false);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @Nullable
    public static PsiClass findApplicationEventPublisher(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "findApplicationEventPublisher"));
        }
        return JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.context.ApplicationEventPublisher", GlobalSearchScope.allScope((Project)project));
    }

    @NotNull
    private static Set<PublishEventPointDescriptor> searchAndCachePublishPoints(@NotNull PsiMethod publishEventMethod, @NotNull SearchScope searchScope) {
        if (publishEventMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishEventMethod", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchAndCachePublishPoints"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchAndCachePublishPoints"));
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)publishEventMethod, () -> {
            if (publishEventMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishEventMethod", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "lambda$searchAndCachePublishPoints$2"));
            }
            if (searchScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "lambda$searchAndCachePublishPoints$2"));
            }
            return CachedValueProvider.Result.create(SpringEventModelUtils.searchPublishPoints(publishEventMethod, searchScope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchAndCachePublishPoints"));
        }
        return set;
    }

    @NotNull
    private static Set<PublishEventPointDescriptor> searchPublishPoints(@NotNull PsiMethod publishEventMethod, @NotNull SearchScope searchScope) {
        if (publishEventMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishEventMethod", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchPublishPoints"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchPublishPoints"));
        }
        LinkedHashSet set = ContainerUtil.newLinkedHashSet();
        MethodReferencesSearch.search((PsiMethod)publishEventMethod, (SearchScope)searchScope, (boolean)true).forEach(psiReference -> {
            PsiExpression[] expressions;
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "lambda$searchPublishPoints$3"));
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
            if (methodCallExpression != null && (expressions = methodCallExpression.getArgumentList().getExpressions()).length == 1) {
                set.add(PublishEventPointDescriptor.create(expressions[0]));
            }
            return true;
        });
        LinkedHashSet linkedHashSet = set;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchPublishPoints"));
        }
        return linkedHashSet;
    }

    @NotNull
    public static Collection<PsiType> getEventListenerHandledType(@NotNull SpringEventListener eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventListener", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListenerHandledType"));
        }
        PsiMethod psiMethod = eventListener.getPsiElement();
        if (psiMethod != null) {
            PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
            if (parameters.length == 1) {
                Set<PsiType> set = Collections.singleton(parameters[0].getType());
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListenerHandledType"));
                }
                return set;
            }
            if (parameters.length == 0) {
                List list = ContainerUtil.mapNotNull(eventListener.getEventListenerClasses(), PsiTypesUtil::getClassType);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListenerHandledType"));
                }
                return list;
            }
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListenerHandledType"));
        }
        return set;
    }

    public static boolean isPublishEventExpression(@NotNull PsiMethodCallExpression psiElement) {
        PsiElement element;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "isPublishEventExpression"));
        }
        PsiReferenceExpression methodExpression = psiElement.getMethodExpression();
        if (PUBLISH_EVENT_METHOD.equals(methodExpression.getReferenceName()) && (element = methodExpression.resolve()) instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return containingClass != null && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.springframework.context.ApplicationEventPublisher");
        }
        return false;
    }
}

