/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.converters.SpringImportResourceConverter;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.values.converters.resources.SpringResourceTypeProvider;
import com.intellij.spring.model.xml.beans.SpringImport;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringImportResourceConverterImpl
extends SpringImportResourceConverter
implements SpringResourceTypeProvider {
    private static final Condition<PsiFileSystemItem> SPRING_XML_CONDITION = item -> {
        if (item.isDirectory()) {
            return false;
        }
        PsiFile file = item.getContainingFile();
        return file instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file));
    };

    public Set<PsiFile> fromString(@Nullable String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        GenericAttributeValue element = (GenericAttributeValue)context.getInvocationElement();
        if (DomUtil.hasXml((DomElement)element) && !s.contains("${")) {
            PsiReference[] references = this.createReferences((GenericDomValue)element, (PsiElement)context.getFile(), context);
            List files = SpringImportResourceConverterImpl.getFiles((PsiReference[])references);
            if (files.isEmpty()) {
                return null;
            }
            return new LinkedHashSet<PsiFile>(files);
        }
        return Collections.emptySet();
    }

    public String toString(@Nullable Set<PsiFile> psiFile, ConvertContext context) {
        return null;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String s = genericDomValue.getStringValue();
        if (s == null || SpringImportResourceConverterImpl.hasTrailingSpace(s) || element == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringImportResourceConverterImpl", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (s.contains("${")) {
            PsiReference[] psiReferenceArray = PlaceholderUtils.getInstance().createPlaceholderPropertiesReferences(genericDomValue);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringImportResourceConverterImpl", "createReferences"));
            }
            return psiReferenceArray;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringImportResourceConverterImpl", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)element, (String)s, (int)1).fromRoot(s.startsWith("/")).filter(SPRING_XML_CONDITION).modules(JamCommonUtil.getAllDependentModules((Module)module));
        PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getReferences(builder);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringImportResourceConverterImpl", "createReferences"));
        }
        return psiReferenceArray;
    }

    @Nullable
    public Condition<PsiFileSystemItem> getResourceFilter(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/spring/model/converters/SpringImportResourceConverterImpl", "getResourceFilter"));
        }
        if (genericDomValue.getParent() instanceof SpringImport) {
            return SPRING_XML_CONDITION;
        }
        return null;
    }

    @Nullable
    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        if (s != null && SpringImportResourceConverterImpl.hasTrailingSpace(s)) {
            return "Trailing space in '" + s + "'";
        }
        return super.getErrorMessage(s, context);
    }

    private static boolean hasTrailingSpace(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/converters/SpringImportResourceConverterImpl", "hasTrailingSpace"));
        }
        return !s.contains("IntellijIdeaRulezzz ") && StringUtil.trimTrailing((String)s).length() != s.length();
    }
}

