/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.converters.SpringDefaultInitDestroyRefConverter;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDefaultInitDestroyRefConverterImpl
extends SpringDefaultInitDestroyRefConverter {
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiMethodPolyVariantReference(element, genericDomValue)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringDefaultInitDestroyRefConverterImpl", "createReferences"));
        }
        return psiReferenceArray;
    }

    public Set<PsiMethod> fromString(@Nullable @NonNls String s, ConvertContext context) {
        return SpringDefaultInitDestroyRefConverterImpl.getMethodsByName((Beans)DomUtil.getParentOfType((DomElement)context.getInvocationElement(), Beans.class, (boolean)false), s);
    }

    public String toString(@Nullable Set<PsiMethod> psiMethods, ConvertContext context) {
        return "";
    }

    @NotNull
    private static Set<PsiMethod> getMethods(@Nullable Beans beans, @NotNull Function<PsiClass, Collection<PsiMethod>> fun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/spring/model/converters/SpringDefaultInitDestroyRefConverterImpl", "getMethods"));
        }
        HashSet methods = new HashSet();
        if (beans != null) {
            for (SpringBean springBean : beans.getBeans()) {
                PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
                if (beanClass == null) continue;
                methods.addAll((Collection)fun.fun((Object)beanClass));
            }
        }
        HashSet hashSet = methods;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringDefaultInitDestroyRefConverterImpl", "getMethods"));
        }
        return hashSet;
    }

    @NotNull
    private static Set<PsiMethod> getMethodsByName(@Nullable Beans beans, @Nullable String methodName) {
        if (!StringUtil.isEmptyOrSpaces((String)methodName)) {
            Set<PsiMethod> set = SpringDefaultInitDestroyRefConverterImpl.getMethods(beans, (Function<PsiClass, Collection<PsiMethod>>)((Function)psiClass -> Arrays.asList(psiClass.findMethodsByName(methodName, true))));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringDefaultInitDestroyRefConverterImpl", "getMethodsByName"));
            }
            return set;
        }
        Set<PsiMethod> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringDefaultInitDestroyRefConverterImpl", "getMethodsByName"));
        }
        return set;
    }

    private static class PsiMethodPolyVariantReference
    extends PsiReferenceBase<PsiElement>
    implements PsiPolyVariantReference {
        private final GenericDomValue<String> myGenericDomValue;

        private PsiMethodPolyVariantReference(PsiElement element, GenericDomValue<String> genericDomValue) {
            super(element);
            this.myGenericDomValue = genericDomValue;
        }

        public PsiElement resolve() {
            ResolveResult[] resolveResults = this.multiResolve(false);
            return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
        }

        public boolean isSoft() {
            return true;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = PsiMethodPolyVariantReference.getAllMethods((Beans)DomUtil.getParentOfType(this.myGenericDomValue, Beans.class, (boolean)false)).toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringDefaultInitDestroyRefConverterImpl$PsiMethodPolyVariantReference", "getVariants"));
            }
            return objectArray;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/converters/SpringDefaultInitDestroyRefConverterImpl$PsiMethodPolyVariantReference", "bindToElement"));
            }
            return element;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            Set methodsByName = SpringDefaultInitDestroyRefConverterImpl.getMethodsByName((Beans)DomUtil.getParentOfType(this.myGenericDomValue, Beans.class, (boolean)false), this.myGenericDomValue.getStringValue());
            ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.map2Array((Collection)methodsByName, ResolveResult.class, PsiElementResolveResult::new);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringDefaultInitDestroyRefConverterImpl$PsiMethodPolyVariantReference", "multiResolve"));
            }
            return resolveResultArray;
        }

        @NotNull
        private static Set<PsiMethod> getAllMethods(@Nullable Beans beans) {
            Set set = SpringDefaultInitDestroyRefConverterImpl.getMethods(beans, (Function<PsiClass, Collection<PsiMethod>>)psiClass -> Arrays.asList(psiClass.getAllMethods()));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringDefaultInitDestroyRefConverterImpl$PsiMethodPolyVariantReference", "getAllMethods"));
            }
            return set;
        }
    }
}

