/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.converters.ConstructorArgNameConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.ConvertContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorArgNameConverterImpl
extends ConstructorArgNameConverter {
    public PsiParameter fromString(@Nullable String s, ConvertContext context) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        SpringBean bean = (SpringBean)SpringConverterUtil.getCurrentBean((ConvertContext)context);
        if (bean == null) {
            return null;
        }
        ResolvedConstructorArgs resolvedArgs = bean.getResolvedConstructorArgs();
        PsiMethod resolvedMethod = resolvedArgs.getResolvedMethod();
        if (resolvedMethod != null) {
            ConstructorArg constructorArg = (ConstructorArg)context.getInvocationElement().getParentOfType(ConstructorArg.class, false);
            Map args = resolvedArgs.getResolvedArgs(resolvedMethod);
            assert (args != null);
            return (PsiParameter)args.get(constructorArg);
        }
        List checkedMethods = resolvedArgs.getCheckedMethods();
        for (PsiMethod method : checkedMethods) {
            for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
                if (!s.equals(psiParameter.getName())) continue;
                return psiParameter;
            }
        }
        return null;
    }

    public String toString(@Nullable PsiParameter beanProperty, ConvertContext context) {
        return null;
    }

    @NotNull
    public Collection<PsiParameter> getVariants(ConvertContext context) {
        Collection<PsiParameter> collection = ConstructorArgNameConverterImpl.getAllConstructorParams(context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/ConstructorArgNameConverterImpl", "getVariants"));
        }
        return collection;
    }

    private static Collection<PsiParameter> getAllConstructorParams(ConvertContext context) {
        HashMap<String, PsiParameter> params = new HashMap<String, PsiParameter>();
        SpringBean springBean = (SpringBean)context.getInvocationElement().getParentOfType(SpringBean.class, false);
        if (springBean != null) {
            List psiMethods = springBean.getInstantiationMethods();
            for (PsiMethod psiMethod : psiMethods) {
                for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                    params.put(parameter.getName(), parameter);
                }
            }
        }
        return params.values();
    }

    public LookupElement createLookupElement(PsiParameter psiParameter) {
        return LookupElementBuilder.create((PsiNamedElement)psiParameter).withIcon(AllIcons.Nodes.Parameter).withTypeText(psiParameter.getType().getPresentableText());
    }
}

