/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.jam;

import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemService;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.model.cacheable.jam.SpringJamBaseCacheableElement;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringJamCustomCacheableElement<T extends PsiMember & PsiNamedElement>
extends SpringJamCacheableElement<T> {
    public static final SemKey<SpringJamCustomCacheableElement> CUSTOM_ROOT_JAM_KEY = CACHEABLE_ROOT_JAM_KEY.subKey("SpringJamCustomCacheableElement", new SemKey[0]);
    private final String[] CACHE_NAMES_ATTRIBUTES = new String[]{"value", "cacheNames"};
    private final NullableLazyValue<SpringJamBaseCacheableElement> myDefiningMetaElement = new NullableLazyValue<SpringJamBaseCacheableElement>(){

        @Nullable
        protected SpringJamBaseCacheableElement compute() {
            PsiClass annotationType;
            PsiAnnotation definingMetaAnnotation = SpringAliasForUtils.findDefiningMetaAnnotation(SpringJamCustomCacheableElement.this.getPsiElement(), (String)SpringJamCustomCacheableElement.this.getAnnotationMeta().getAnnoName(), (String)SpringJamCustomCacheableElement.this.getDefiningAnnotation());
            if (definingMetaAnnotation != null && (annotationType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)definingMetaAnnotation, PsiClass.class, (boolean)true)) != null) {
                return (SpringJamBaseCacheableElement)SemService.getSemService((Project)annotationType.getProject()).getSemElement(SpringJamBaseCacheableElement.CACHEABLE_BASE_JAM_KEY, (PsiElement)annotationType);
            }
            return null;
        }
    };

    public SpringJamCustomCacheableElement(String annoName, T t) {
        super(t, annoName);
    }

    protected abstract String getDefiningAnnotation();

    @Override
    @NotNull
    public Set<String> getCacheNames() {
        LinkedHashSet names = ContainerUtil.newLinkedHashSet();
        for (String attrName : this.CACHE_NAMES_ATTRIBUTES) {
            SpringAliasFor aliasFor = this.getAliasAttribute(attrName);
            if (aliasFor == null) continue;
            JamStringAttributeMeta.Collection collection = JamAttributeMeta.collectionString((String)aliasFor.getMethodName());
            for (JamStringAttributeElement stringAttributeElement : collection.getJam(this.getAnnotationMeta().getAnnotationRef(this.getPsiElement()))) {
                ContainerUtil.addIfNotNull((Collection)names, (Object)stringAttributeElement.getValue());
            }
            LinkedHashSet linkedHashSet = names;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/jam/SpringJamCustomCacheableElement", "getCacheNames"));
            }
            return linkedHashSet;
        }
        SpringJamBaseCacheableElement baseCacheableElement = (SpringJamBaseCacheableElement)this.myDefiningMetaElement.getValue();
        if (baseCacheableElement != null) {
            Set<String> set = baseCacheableElement.getCacheNames();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/jam/SpringJamCustomCacheableElement", "getCacheNames"));
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/jam/SpringJamCustomCacheableElement", "getCacheNames"));
        }
        return set;
    }

    private SpringAliasFor getAliasAttribute(@NotNull String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/spring/model/cacheable/jam/SpringJamCustomCacheableElement", "getAliasAttribute"));
        }
        return SpringAliasForUtils.findAliasFor(this.getPsiElement(), (String)this.getAnnotationMeta().getAnnoName(), (String)this.getDefiningAnnotation(), (String)attrName);
    }
}

