/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.cacheable.highlighting.SpringCacheableBaseInspection;
import com.intellij.spring.model.cacheable.jam.SpringJamBaseCacheableElement;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheConfig;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheConfig;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCacheNamesInspection
extends SpringCacheableBaseInspection {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/cacheable/highlighting/SpringCacheNamesInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/cacheable/highlighting/SpringCacheNamesInspection", "checkMethod"));
        }
        if (SpringCacheNamesInspection.isPlainJavaFileInSpringModule((PsiElement)method)) {
            ProblemsHolder holder = new ProblemsHolder(manager, method.getContainingFile(), isOnTheFly);
            List elements = SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, (PsiElement)method);
            SpringCacheNamesInspection.checkCacheNames(method.getContainingClass(), holder, elements);
            return holder.getResultsArray();
        }
        return null;
    }

    private static boolean hasDefaultCacheNamesOrCustomCacheResolver(@Nullable PsiClass aClass) {
        if (aClass != null) {
            SemService service = SemService.getSemService((Project)aClass.getProject());
            SpringJamCacheConfig cacheConfig = (SpringJamCacheConfig)service.getSemElement(SpringJamCacheConfig.CACHE_CONFIG_JAM_KEY, (PsiElement)aClass);
            if (cacheConfig != null) {
                return !cacheConfig.getCacheNamesElement().isEmpty() || cacheConfig.getCacheResolverElement().getValue() != null;
            }
            SpringJamCustomCacheConfig customCacheConfig = (SpringJamCustomCacheConfig)service.getSemElement(SpringJamCustomCacheConfig.JAM_KEY, (PsiElement)aClass);
            if (customCacheConfig != null) {
                return !customCacheConfig.getCacheNames().isEmpty();
            }
        }
        return false;
    }

    private static void checkCacheNames(@Nullable PsiClass containingClass, ProblemsHolder holder, List<SpringJamCacheableElement> elements) {
        if (SpringCacheNamesInspection.hasDefaultCacheNamesOrCustomCacheResolver(containingClass)) {
            return;
        }
        for (SpringJamCacheableElement cacheable : elements) {
            PsiAnnotation annotation;
            if (cacheable instanceof SpringJamCacheConfig || !cacheable.getCacheNames().isEmpty() || SpringCacheNamesInspection.hasCustomCacheResolver(cacheable) || (annotation = cacheable.getAnnotation()) == null) continue;
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("cacheable.no.cache.could.be.resolved.for.cache.operation", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static boolean hasCustomCacheResolver(SpringJamCacheableElement cacheable) {
        if (cacheable instanceof SpringJamBaseCacheableElement) {
            return ((SpringJamBaseCacheableElement)cacheable).getCacheResolverElement().getValue() != null;
        }
        return false;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/cacheable/highlighting/SpringCacheNamesInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/cacheable/highlighting/SpringCacheNamesInspection", "checkClass"));
        }
        if (SpringCacheNamesInspection.isPlainJavaFileInSpringModule((PsiElement)aClass) && aClass.isInterface() && !aClass.isAnnotationType()) {
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            SpringCacheNamesInspection.checkCacheNames(aClass, holder, SemService.getSemService((Project)aClass.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, (PsiElement)aClass));
            return holder.getResultsArray();
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringCacheNamesInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/highlighting/SpringCacheNamesInspection", "getShortName"));
        }
        return "SpringCacheNamesInspection";
    }
}

