/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.cacheable.highlighting.SpringCacheableBaseInspection;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCacheAnnotationsOnInterfaceInspection
extends SpringCacheableBaseInspection {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiClass containingClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/cacheable/highlighting/SpringCacheAnnotationsOnInterfaceInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/cacheable/highlighting/SpringCacheAnnotationsOnInterfaceInspection", "checkMethod"));
        }
        if (SpringCacheAnnotationsOnInterfaceInspection.isPlainJavaFileInSpringModule((PsiElement)method) && (containingClass = method.getContainingClass()) != null && containingClass.isInterface()) {
            ProblemsHolder holder = new ProblemsHolder(manager, method.getContainingFile(), isOnTheFly);
            for (SpringJamCacheableElement cacheableElement : SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, (PsiElement)method)) {
                SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, cacheableElement.getAnnotation());
            }
            SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"org.springframework.cache.annotation.Caching"}));
            return holder.getResultsArray();
        }
        return null;
    }

    private static void registerProblemIfAnnotationExists(@NotNull ProblemsHolder holder, @Nullable PsiAnnotation annotation) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/cacheable/highlighting/SpringCacheAnnotationsOnInterfaceInspection", "registerProblemIfAnnotationExists"));
        }
        if (annotation != null) {
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("cacheable.should.be.defined.on.concrete.method", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/cacheable/highlighting/SpringCacheAnnotationsOnInterfaceInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/cacheable/highlighting/SpringCacheAnnotationsOnInterfaceInspection", "checkClass"));
        }
        if (SpringCacheAnnotationsOnInterfaceInspection.isPlainJavaFileInSpringModule((PsiElement)aClass) && aClass.isInterface() && !aClass.isAnnotationType()) {
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            for (SpringJamCacheableElement cacheableElement : SemService.getSemService((Project)aClass.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, (PsiElement)aClass)) {
                SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, cacheableElement.getAnnotation());
            }
            SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{"org.springframework.cache.annotation.Caching"}));
            return holder.getResultsArray();
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringCacheAnnotationsOnInterfaceInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/highlighting/SpringCacheAnnotationsOnInterfaceInspection", "getShortName"));
        }
        return "SpringCacheAnnotationsOnInterfaceInspection";
    }
}

