/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.aop;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.actions.GenerateSpringDomElementAction;
import com.intellij.spring.model.actions.generate.SpringBeanGenerateProvider;
import com.intellij.spring.model.actions.patterns.PatternActionAdapter;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import com.intellij.xml.util.XmlUtil;
import icons.SpringApiIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AopPatternsGroup
extends PatternActionAdapter {
    public AopPatternsGroup() {
        super("AopPatternsGroup");
        this.add(new GenerateSpringDomElementAction((GenerateDomElementProvider)new SpringBeanGenerateProvider(SpringBundle.message("spring.patterns.aop.auto.proxy.creator", new Object[0]), "aop-auto-proxy-creator")));
        this.add(new GenerateSpringDomElementAction((GenerateDomElementProvider)new SpringBeanGenerateProvider(SpringBundle.message("spring.patterns.aop.auto.proxy", new Object[0]), "aop-auto-proxy"){

            protected Map<String, String> getPredefinedVars(@Nullable DomElement parentDomElement, @Nullable SpringBean springBean, @NotNull Editor editor, @NotNull PsiFile file) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/spring/model/actions/patterns/aop/AopPatternsGroup$1", "getPredefinedVars"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/model/actions/patterns/aop/AopPatternsGroup$1", "getPredefinedVars"));
                }
                Map map = super.getPredefinedVars(parentDomElement, (DomElement)springBean, editor, file);
                String prefix = AopPatternsGroup.getAopNamespacePrefix((XmlFile)file);
                if (!StringUtil.isEmptyOrSpaces((String)prefix)) {
                    map.put("AOP_NS_PREFIX", prefix + ":");
                }
                return map;
            }
        }){

            public boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/actions/patterns/aop/AopPatternsGroup$2", "isValidForFile"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/spring/model/actions/patterns/aop/AopPatternsGroup$2", "isValidForFile"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/model/actions/patterns/aop/AopPatternsGroup$2", "isValidForFile"));
                }
                return super.isValidForFile(project, editor, file) && file instanceof XmlFile && AopPatternsGroup.getAopNamespacePrefix((XmlFile)file) != null;
            }
        });
    }

    @Nullable
    public static String getAopNamespacePrefix(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/spring/model/actions/patterns/aop/AopPatternsGroup", "getAopNamespacePrefix"));
        }
        return XmlUtil.findNamespacePrefixByURI((XmlFile)xmlFile, (String)"http://www.springframework.org/schema/aop");
    }

    protected String getDescription() {
        return SpringBundle.message("spring.patterns.aop.group.name", new Object[0]);
    }

    public Icon getIcon() {
        return SpringApiIcons.Spring;
    }
}

