/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.actions.BaseGenerateAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.actions.GenerateSpringBeanDependenciesActionHandler;
import com.intellij.spring.model.actions.generate.GenerateSpringBeanDependenciesUtil;
import icons.SpringApiIcons;
import org.jetbrains.annotations.NotNull;

public abstract class GenerateSpringBeanDependencyAction
extends BaseGenerateAction {
    public GenerateSpringBeanDependencyAction(CodeInsightActionHandler handler, String text) {
        super(handler);
        this.getTemplatePresentation().setText(text);
        this.getTemplatePresentation().setIcon(SpringApiIcons.Spring);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/actions/GenerateSpringBeanDependencyAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/spring/model/actions/GenerateSpringBeanDependencyAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/model/actions/GenerateSpringBeanDependencyAction", "isValidForFile"));
        }
        if (!super.isValidForFile(project, editor, file)) {
            return false;
        }
        PsiClass psiClass = this.getTargetClass(editor, file);
        if (psiClass == null || psiClass.isInterface() || psiClass.isEnum() || psiClass.getQualifiedName() == null) {
            return false;
        }
        Module module = GenerateSpringBeanDependenciesUtil.getSpringModule(psiClass);
        return module != null && this.checkContext(module);
    }

    protected boolean checkContext(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/actions/GenerateSpringBeanDependencyAction", "checkContext"));
        }
        if (this.isXmlBasedAction()) {
            SpringModel model = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
            for (PsiFile file : model.getConfigFiles()) {
                if (!(file instanceof XmlFile)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean isXmlBasedAction() {
        return true;
    }

    protected boolean acceptPsiClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/actions/GenerateSpringBeanDependencyAction", "acceptPsiClass"));
        }
        return GenerateSpringBeanDependenciesUtil.acceptPsiClass(psiClass, this.isSetterDependency());
    }

    private boolean isSetterDependency() {
        return ((GenerateSpringBeanDependenciesActionHandler)this.getHandler()).isSetterDependency();
    }
}

