/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.DerivedSpringBeanPointer;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBaseBeanPointer<T extends CommonSpringBean>
implements SpringBeanPointer<T> {
    private final String myName;
    private final Project myProject;
    private CachedValue<PsiType[]> effectiveTypesValue;
    private final VolatileNotNullLazyValue<String[]> myAliases;

    protected SpringBaseBeanPointer(@Nullable String name, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/SpringBaseBeanPointer", "<init>"));
        }
        this.myAliases = new VolatileNotNullLazyValue<String[]>(){

            @NotNull
            protected String[] compute() {
                String[] stringArray = SpringBaseBeanPointer.this.getSpringBean().getAliases();
                if (stringArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringBaseBeanPointer$1", "compute"));
                }
                return stringArray;
            }
        };
        this.myName = name;
        this.myProject = project;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public PsiClass[] getEffectiveBeanType() {
        return (PsiClass[])ContainerUtil.mapNotNull((Object[])this.getEffectiveBeanTypes(), PsiTypesUtil::getPsiClass, (Object[])PsiClass.EMPTY_ARRAY);
    }

    public PsiType[] getEffectiveBeanTypes() {
        if (this.effectiveTypesValue == null) {
            this.effectiveTypesValue = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> {
                PsiType[] types = BeanService.getInstance().getEffectiveBeanTypes(this.getSpringBean());
                return CachedValueProvider.Result.createSingleDependency((Object)types, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
            }, false);
        }
        return (PsiType[])this.effectiveTypesValue.getValue();
    }

    public String[] getAliases() {
        return (String[])this.myAliases.getValue();
    }

    @NotNull
    public SpringBeanPointer getBasePointer() {
        SpringBaseBeanPointer springBaseBeanPointer = this;
        if (springBaseBeanPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringBaseBeanPointer", "getBasePointer"));
        }
        return springBaseBeanPointer;
    }

    public SpringBeanPointer derive(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/SpringBaseBeanPointer", "derive"));
        }
        return Comparing.equal((String)name, (String)this.getName()) ? this : new DerivedSpringBeanPointer(this, name);
    }

    public boolean isReferenceTo(@Nullable CommonSpringBean springBean) {
        if (springBean == null) {
            return false;
        }
        PsiFile file = springBean.getContainingFile();
        return file != null && file.equals(this.getContainingFile()) && springBean.equals(this.getSpringBean());
    }

    public boolean isAbstract() {
        return false;
    }

    @Nullable
    public SpringBeanPointer getParentPointer() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpringBeanPointer)) {
            return false;
        }
        SpringBeanPointer that = (SpringBeanPointer)o;
        return Comparing.equal((String)this.myName, (String)that.getName()) && Comparing.equal((Object)this.getPsiElement(), (Object)that.getPsiElement());
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.myName + "]";
    }

    protected Project getProject() {
        return this.myProject;
    }
}

