/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsManager;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.impl.SpringCachedModelFactory;
import com.intellij.spring.impl.SpringCombinedModelFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringManagerImpl
extends SpringManager {
    private static final Key<CachedValue<Set<SpringModel>>> ALL_MODELS_MODULE_WITH_DEPS = Key.create((String)"ALL_MODELS_MODULE_WITH_DEPS");
    private final Project myProject;

    public SpringManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Object[] getModelsDependencies(@NotNull Module module, Object ... additional) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getModelsDependencies"));
        }
        ArrayList<Object> dependencies = new ArrayList<Object>(6);
        Collections.addAll(dependencies, additional);
        Object[] objectArray = SpringManagerImpl.addModuleModelsDependencies(module, dependencies).toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getModelsDependencies"));
        }
        return objectArray;
    }

    @NotNull
    private static Collection<Object> addModuleModelsDependencies(@NotNull Module module, Collection<Object> dependencies) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "addModuleModelsDependencies"));
        }
        Project project = module.getProject();
        SpringModificationTrackersManager modificationTrackersManager = SpringModificationTrackersManager.getInstance((Project)project);
        dependencies.add(modificationTrackersManager.getProfilesModificationTracker());
        dependencies.add(modificationTrackersManager.getMultipleContextsModificationTracker());
        dependencies.add(ProjectRootManager.getInstance((Project)project));
        dependencies.add(FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID));
        SpringFacet facet = SpringFacet.getInstance((Module)module);
        if (facet != null) {
            dependencies.add(facet.getConfiguration());
        }
        Collection<Object> collection = dependencies;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "addModuleModelsDependencies"));
        }
        return collection;
    }

    @NotNull
    public Set<SpringModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getAllModels"));
        }
        Set set = (Set)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)module, ALL_MODELS_MODULE_WITH_DEPS, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "lambda$getAllModels$0"));
            }
            Set<SpringModel> models = SpringManagerImpl.computeAllModels(module, true);
            Object[] dependencies = this.getModelsDependencies(module, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
            return CachedValueProvider.Result.create(models, (Object[])dependencies);
        }, false);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getAllModels"));
        }
        return set;
    }

    @NotNull
    public Set<SpringModel> getAllModelsWithoutDependencies(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getAllModelsWithoutDependencies"));
        }
        Set<SpringModel> set = SpringCombinedModelFactory.getAllModelsWithoutDependencies(module);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getAllModelsWithoutDependencies"));
        }
        return set;
    }

    @NotNull
    public SpringModel getCombinedModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getCombinedModel"));
        }
        CombinedSpringModelImpl combinedSpringModelImpl = new CombinedSpringModelImpl(this.getAllModels(module), module);
        if (combinedSpringModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getCombinedModel"));
        }
        return combinedSpringModelImpl;
    }

    private static Set<SpringModel> computeAllModels(@NotNull Module module, boolean withDependentModules) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "computeAllModels"));
        }
        LinkedHashSet<SpringModel> result = new LinkedHashSet<SpringModel>();
        ModuleUtilCore.ModuleVisitor visitor = visitModule -> {
            Set<SpringModel> models = SpringCombinedModelFactory.getAllModelsWithoutDependencies(visitModule);
            result.addAll(models);
            return true;
        };
        if (withDependentModules) {
            ModuleUtilCore.visitMeAndDependentModules((Module)module, (ModuleUtilCore.ModuleVisitor)visitor);
            LinkedHashSet dependencies = new LinkedHashSet();
            ModuleUtilCore.getDependencies((Module)module, dependencies);
            dependencies.remove(module);
            for (Module dep : dependencies) {
                visitor.visit(dep);
            }
        } else {
            visitor.visit(module);
        }
        SpringCombinedModelFactory.setDependencies(result);
        return result;
    }

    @NotNull
    public Set<SpringModel> getSpringModelsByFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/impl/SpringManagerImpl", "getSpringModelsByFile"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getSpringModelsByFile"));
            }
            return set;
        }
        Set<SpringModel> models = SpringCombinedModelFactory.findModelsInScope(file, module);
        if (!models.isEmpty()) {
            Set<SpringModel> set = models;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getSpringModelsByFile"));
            }
            return set;
        }
        SpringModel model = SpringCombinedModelFactory.createSingleModel(file, module);
        Set set = ContainerUtil.createMaybeSingletonSet((Object)model);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getSpringModelsByFile"));
        }
        return set;
    }

    @Nullable
    public SpringModel getSpringModelByFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/impl/SpringManagerImpl", "getSpringModelByFile"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return null;
        }
        Set<SpringModel> allModels = this.getSpringModelsByFile(file);
        if (allModels.size() == 1) {
            return allModels.iterator().next();
        }
        SpringContextDescriptor descriptor = SpringMultipleContextsManager.getInstance().getContextDescriptor(file);
        if (descriptor.equals((Object)SpringContextDescriptor.LOCAL_CONTEXT)) {
            return SpringCombinedModelFactory.createSingleModel(file, module);
        }
        if (descriptor.equals((Object)SpringContextDescriptor.ALL_CONTEXTS)) {
            return new CombinedSpringModelImpl(allModels, module);
        }
        String descriptorId = descriptor.getId();
        Module descriptorModule = descriptor.getModule();
        if (descriptorModule != null) {
            for (SpringModel model : allModels) {
                SpringFileSet fileSet = model.getFileSet();
                if (fileSet == null || !descriptorId.equals(fileSet.getId()) || !descriptorModule.equals(model.getModule())) continue;
                return model;
            }
        }
        return null;
    }

    @Nullable
    public LocalXmlModel getLocalSpringModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/impl/SpringManagerImpl", "getLocalSpringModel"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return module == null ? null : this.getLocalSpringModel(file, module);
    }

    @Nullable
    public LocalXmlModel getLocalSpringModel(@NotNull XmlFile file, @NotNull Module module) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/impl/SpringManagerImpl", "getLocalSpringModel"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getLocalSpringModel"));
        }
        return SpringCachedModelFactory.getOrCreateLocalXmlModel(file, module, null);
    }

    @Nullable
    public LocalAnnotationModel getLocalSpringModel(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/impl/SpringManagerImpl", "getLocalSpringModel"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        return module == null ? null : this.getLocalSpringModel(psiClass, module);
    }

    @Nullable
    public LocalAnnotationModel getLocalSpringModel(@NotNull PsiClass psiClass, @NotNull Module module) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/impl/SpringManagerImpl", "getLocalSpringModel"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getLocalSpringModel"));
        }
        return SpringCachedModelFactory.getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet());
    }
}

