/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelImpl;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.LocalXmlModelImpl;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCachedModelFactory {
    private static final Key<CachedValue<Map<Pair<Module, String>, LocalXmlModel>>> LOCAL_XML_MODEL_KEY = Key.create((String)"LOCAL_XML_MODEL_KEY");
    private static final Key<CachedValue<Map<Pair<Module, String>, LocalAnnotationModel>>> LOCAL_ANNO_MODEL_KEY = Key.create((String)"LOCAL_ANN_MODEL_KEY");

    @Nullable
    public static LocalXmlModel getOrCreateLocalXmlModel(final @NotNull XmlFile configFile, @NotNull Module module, @Nullable Set<String> activeProfiles) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/impl/SpringCachedModelFactory", "getOrCreateLocalXmlModel"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringCachedModelFactory", "getOrCreateLocalXmlModel"));
        }
        if (module.isDisposed()) {
            return null;
        }
        Pair key = Pair.create((Object)module, (Object)SpringProfileUtils.profilesAsString(activeProfiles));
        Map localXmlModelsMap = (Map)CachedValuesManager.getManager((Project)configFile.getProject()).getCachedValue((UserDataHolder)configFile, LOCAL_XML_MODEL_KEY, () -> {
            if (configFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/impl/SpringCachedModelFactory", "lambda$getOrCreateLocalXmlModel$0"));
            }
            ConcurrentFactoryMap<Pair<Module, String>, LocalXmlModel> localXmlModelTHashMap = new ConcurrentFactoryMap<Pair<Module, String>, LocalXmlModel>(){

                protected LocalXmlModel create(Pair<Module, String> key1) {
                    LocalXmlModelImpl localXmlModel = new LocalXmlModelImpl(configFile, (Module)key1.first);
                    Set profiles = SpringCachedModelFactory.getProfilesFromString((String)key1.second);
                    localXmlModel.setActiveProfiles(profiles);
                    return localXmlModel;
                }
            };
            return CachedValueProvider.Result.create((Object)localXmlModelTHashMap, (Object[])SpringCachedModelFactory.getLocalXmlModelDependencies((PsiFile)configFile));
        }, false);
        return (LocalXmlModel)localXmlModelsMap.get(key);
    }

    @Nullable
    public static LocalAnnotationModel getOrCreateLocalAnnotationModel(@NotNull SpringConfiguration configuration, @Nullable Module module, @NotNull Set<String> activeProfiles) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/impl/SpringCachedModelFactory", "getOrCreateLocalAnnotationModel"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/impl/SpringCachedModelFactory", "getOrCreateLocalAnnotationModel"));
        }
        if (module == null) {
            return null;
        }
        return SpringCachedModelFactory.getOrCreateLocalAnnotationModel(configuration.getPsiElement(), module, activeProfiles);
    }

    @Nullable
    public static LocalAnnotationModel getOrCreateLocalAnnotationModel(final @NotNull PsiClass psiClass, final @NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/impl/SpringCachedModelFactory", "getOrCreateLocalAnnotationModel"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringCachedModelFactory", "getOrCreateLocalAnnotationModel"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/impl/SpringCachedModelFactory", "getOrCreateLocalAnnotationModel"));
        }
        if (module.isDisposed()) {
            return null;
        }
        Pair key = Pair.create((Object)module, (Object)SpringProfileUtils.profilesAsString(activeProfiles));
        Map localAnnotationModelsMap = (Map)CachedValuesManager.getManager((Project)psiClass.getProject()).getCachedValue((UserDataHolder)psiClass, LOCAL_ANNO_MODEL_KEY, () -> {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/impl/SpringCachedModelFactory", "lambda$getOrCreateLocalAnnotationModel$1"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringCachedModelFactory", "lambda$getOrCreateLocalAnnotationModel$1"));
            }
            ConcurrentFactoryMap<Pair<Module, String>, LocalAnnotationModel> localAnnoModelTHashMap = new ConcurrentFactoryMap<Pair<Module, String>, LocalAnnotationModel>(){

                protected LocalAnnotationModel create(Pair<Module, String> key1) {
                    LocalAnnotationModelImpl annotationModel = new LocalAnnotationModelImpl(psiClass, module);
                    Set profiles = Collections.unmodifiableSet(SpringCachedModelFactory.getProfilesFromString((String)key1.second));
                    annotationModel.setActiveProfiles(profiles);
                    return annotationModel;
                }
            };
            return CachedValueProvider.Result.create((Object)localAnnoModelTHashMap, (Object[])SpringCachedModelFactory.getLocalAnnotationModelDependencies(psiClass));
        }, false);
        return (LocalAnnotationModel)localAnnotationModelsMap.get(key);
    }

    @NotNull
    private static Set<String> getProfilesFromString(String key) {
        if (key.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringCachedModelFactory", "getProfilesFromString"));
            }
            return set;
        }
        Set set = ContainerUtil.map2Set((Collection)StringUtil.split((String)key, (String)","), (Function)StringUtil.TRIMMER);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringCachedModelFactory", "getProfilesFromString"));
        }
        return set;
    }

    @NotNull
    private static Object[] getLocalXmlModelDependencies(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/spring/impl/SpringCachedModelFactory", "getLocalXmlModelDependencies"));
        }
        Project project = psiFile.getProject();
        SpringModificationTrackersManager springModificationTrackersManager = SpringModificationTrackersManager.getInstance((Project)project);
        Object[] dependencies = new Object[]{psiFile, springModificationTrackersManager.getProfilesModificationTracker(), springModificationTrackersManager.getCustomBeanParserModificationTracker(), ProjectRootManager.getInstance((Project)project), springModificationTrackersManager.getOuterModelsModificationTracker()};
        if (dependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringCachedModelFactory", "getLocalXmlModelDependencies"));
        }
        return dependencies;
    }

    @NotNull
    private static Object[] getLocalAnnotationModelDependencies(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/impl/SpringCachedModelFactory", "getLocalAnnotationModelDependencies"));
        }
        Project project = psiClass.getProject();
        SpringModificationTrackersManager springModificationTrackersManager = SpringModificationTrackersManager.getInstance((Project)project);
        Object[] dependencies = new Object[]{psiClass, springModificationTrackersManager.getProfilesModificationTracker(), springModificationTrackersManager.getMultipleContextsModificationTracker(), ProjectRootManager.getInstance((Project)project), springModificationTrackersManager.getOuterModelsModificationTracker()};
        if (dependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringCachedModelFactory", "getLocalAnnotationModelDependencies"));
        }
        return dependencies;
    }
}

