/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.factories.ObjectTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.util.SpringConstant;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilConstantTypeResolver
implements ObjectTypeResolver {
    @NonNls
    private static final String FACTORY_CLASS = "org.springframework.beans.factory.config.FieldRetrievingFactoryBean";
    @NonNls
    private static final char SEPARATOR = '.';

    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        SpringConstant constant;
        String staticField;
        int lastDotIndex;
        if (context instanceof SpringConstant && (lastDotIndex = (staticField = StringUtil.notNullize((String)(constant = (SpringConstant)context).getStaticField().getStringValue())).lastIndexOf(46)) != -1) {
            PsiField psiField;
            String className = staticField.substring(0, lastDotIndex);
            String fieldName = staticField.substring(lastDotIndex + 1);
            PsiClass psiClass = UtilConstantTypeResolver.findClassByExternalName(context, className);
            if (psiClass != null && (psiField = psiClass.findFieldByName(fieldName, true)) != null) {
                String qualifiedName;
                PsiClass typeClass;
                PsiType type = psiField.getType();
                if (type instanceof PsiPrimitiveType) {
                    String boxedTypeName = ((PsiPrimitiveType)type).getBoxedTypeName();
                    Set<String> set = Collections.singleton(boxedTypeName);
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/UtilConstantTypeResolver", "getObjectType"));
                    }
                    return set;
                }
                if (type instanceof PsiClassType && (typeClass = ((PsiClassType)type).resolve()) != null && (qualifiedName = typeClass.getQualifiedName()) != null) {
                    Set<String> set = Collections.singleton(qualifiedName);
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/UtilConstantTypeResolver", "getObjectType"));
                    }
                    return set;
                }
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/UtilConstantTypeResolver", "getObjectType"));
        }
        return set;
    }

    @Nullable
    private static PsiClass findClassByExternalName(@NotNull CommonSpringBean context, @NotNull String externalName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/factories/resolvers/UtilConstantTypeResolver", "findClassByExternalName"));
        }
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/spring/factories/resolvers/UtilConstantTypeResolver", "findClassByExternalName"));
        }
        Module module = context.getModule();
        if (module != null) {
            GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
            PsiManager psiManager = context.getPsiManager();
            String className = externalName.replace('$', '.');
            return JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(className, scope);
        }
        return null;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClassName", "com/intellij/spring/factories/resolvers/UtilConstantTypeResolver", "accept"));
        }
        return factoryClassName.equals(FACTORY_CLASS);
    }
}

