/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.factories.ObjectTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleObjectTypeResolver
implements ObjectTypeResolver {
    private final Set<String> myTypes;

    public SingleObjectTypeResolver(String type) {
        this.myTypes = new HashSet<String>(StringUtil.split((String)type, (String)";"));
    }

    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean bean) {
        Set<String> set = this.myTypes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/SingleObjectTypeResolver", "getObjectType"));
        }
        return set;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClassName", "com/intellij/spring/factories/resolvers/SingleObjectTypeResolver", "accept"));
        }
        return true;
    }
}

