/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.spring.factories.resolvers.AbstractTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyBatisPlaceMapperTypeResolver
extends AbstractTypeResolver {
    private static final String MAPPER_FACTORY_BEAN = "org.mybatis.spring.mapper.MapperFactoryBean";

    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        String value;
        SpringBean springBean;
        SpringPropertyDefinition mapperInterface;
        if (context instanceof SpringBean && (mapperInterface = SpringPropertyUtils.findPropertyByName((CommonSpringBean)(springBean = (SpringBean)context), (String)"mapperInterface")) != null && (value = mapperInterface.getValueAsString()) != null) {
            Set<String> set = Collections.singleton(value);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/MyBatisPlaceMapperTypeResolver", "getObjectType"));
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/MyBatisPlaceMapperTypeResolver", "getObjectType"));
        }
        return set;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClassName", "com/intellij/spring/factories/resolvers/MyBatisPlaceMapperTypeResolver", "accept"));
        }
        return MAPPER_FACTORY_BEAN.equals(factoryClassName);
    }
}

