/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.spring.factories.resolvers.AbstractTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactoryPropertiesDependentTypeResolver
extends AbstractTypeResolver {
    private final List<String> myPropertyNames;

    public FactoryPropertiesDependentTypeResolver(List<String> propertyNames) {
        this.myPropertyNames = propertyNames;
    }

    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        for (String propertyName : this.myPropertyNames) {
            String propertyValue = FactoryPropertiesDependentTypeResolver.getPropertyValue(context, propertyName);
            if (propertyValue == null) continue;
            Set<String> set = Collections.singleton(propertyValue);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/FactoryPropertiesDependentTypeResolver", "getObjectType"));
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/FactoryPropertiesDependentTypeResolver", "getObjectType"));
        }
        return set;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClassName", "com/intellij/spring/factories/resolvers/FactoryPropertiesDependentTypeResolver", "accept"));
        }
        return true;
    }
}

