/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.facet.SpringFrameworkDetector;
import com.intellij.spring.facet.validation.SpringConfigurationCheckTask;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;

public class SpringConfigurationCheckStartupActivity
implements StartupActivity {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/facet/validation/SpringConfigurationCheckStartupActivity", "runActivity"));
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        application.executeOnPooledThread(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/facet/validation/SpringConfigurationCheckStartupActivity", "lambda$runActivity$2"));
            }
            Boolean isFrameworkDetectionExcluded = (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/facet/validation/SpringConfigurationCheckStartupActivity", "lambda$null$0"));
                }
                DetectionExcludesConfiguration detectionExcludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)project);
                return detectionExcludesConfiguration.isExcludedFromDetection(SpringFrameworkDetector.SPRING_FRAMEWORK_TYPE);
            });
            if (isFrameworkDetectionExcluded.booleanValue()) {
                return;
            }
            Boolean hasSpringSupport = (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/facet/validation/SpringConfigurationCheckStartupActivity", "lambda$null$1"));
                }
                return SpringCommonUtils.hasSpringFacets((Project)project) || SpringLibraryUtil.hasSpringLibrary((Project)project);
            });
            if (!hasSpringSupport.booleanValue()) {
                return;
            }
            ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstanceImpl((Project)project);
            if (profileManager.isCurrentProfileInitialized()) {
                SpringConfigurationCheckStartupActivity.queueTask(project);
                return;
            }
            profileManager.addProfileChangeListener(new ProfileChangeAdapter(){

                public void profilesInitialized() {
                    SpringConfigurationCheckStartupActivity.queueTask(project);
                }
            }, (Disposable)project);
        });
    }

    private static void queueTask(Project project) {
        ApplicationManager.getApplication().invokeLater(() -> new SpringConfigurationCheckTask(project).queue(), project.getDisposed());
    }
}

