/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom.namespaces;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpringBeanNamespaceDescriptor<T extends PsiElement>
extends XmlNSDescriptorImpl {
    static final String REF_SUFFIX = "-ref";

    public XmlAttributeDescriptor getAttribute(String localName, String namespace, XmlTag context) {
        if (this.getNamespace().equals(namespace)) {
            String sanitizedLocalName = AbstractSpringBeanNamespaceDescriptor.attributeNameToPropertyName(localName);
            for (XmlAttributeDescriptor descriptor : this.getAttributeDescriptors(context)) {
                if (!descriptor.getName().equals(sanitizedLocalName)) continue;
                return descriptor;
            }
        }
        return super.getAttribute(localName, namespace, context);
    }

    public static String attributeNameToPropertyName(String attributeName) {
        String realAttributeName = StringUtil.trimEnd((String)attributeName, (String)REF_SUFFIX);
        if (!realAttributeName.contains("-")) {
            return realAttributeName;
        }
        char[] chars = realAttributeName.toCharArray();
        char[] result = new char[chars.length - 1];
        int currPos = 0;
        boolean upperCaseNext = false;
        for (char c : chars) {
            if (c == '-') {
                upperCaseNext = true;
                continue;
            }
            if (upperCaseNext) {
                result[currPos++] = Character.toUpperCase(c);
                upperCaseNext = false;
                continue;
            }
            result[currPos++] = c;
        }
        return new String(result, 0, currPos);
    }

    protected abstract String getNamespace();

    @Nullable
    protected static SpringBean getSpringBean(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor", "getSpringBean"));
        }
        DomElement element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        if (element instanceof SpringBean) {
            return (SpringBean)element;
        }
        return null;
    }

    @Nullable
    protected static PsiClass getClass(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor", "getClass"));
        }
        DomElement element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        if (element instanceof SpringBean) {
            SpringBean bean = (SpringBean)element;
            return PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType(true));
        }
        return null;
    }

    private XmlAttributeDescriptor[] getAttributeDescriptors(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor", "getAttributeDescriptors"));
        }
        SpringBean springBean = AbstractSpringBeanNamespaceDescriptor.getSpringBean(tag);
        if (springBean == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        Map<String, T> properties = this.getAttributesWithoutRecursion(springBean);
        if (properties.isEmpty()) {
            return XmlAttributeDescriptor.EMPTY;
        }
        ArrayList<SpringBeanAttributeDescriptor> result = new ArrayList<SpringBeanAttributeDescriptor>(properties.size() * 2);
        for (String attrName : properties.keySet()) {
            PsiElement t = (PsiElement)properties.get(attrName);
            result.add(this.createAttributeDescriptor(attrName, t, ""));
            PsiType attributeType = this.getAttributeType(t);
            if (!(attributeType instanceof PsiClassType) && !(attributeType instanceof PsiArrayType)) continue;
            result.add(this.createAttributeDescriptor(attrName, t, REF_SUFFIX));
        }
        return result.toArray(new XmlAttributeDescriptor[result.size()]);
    }

    @NotNull
    private Map<String, T> getAttributesWithoutRecursion(@NotNull SpringBean springBean) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor", "getAttributesWithoutRecursion"));
        }
        PsiElement identifyingPsiElement = springBean.getIdentifyingPsiElement();
        if (identifyingPsiElement == null || !identifyingPsiElement.isValid()) {
            Map map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor", "getAttributesWithoutRecursion"));
            }
            return map;
        }
        Map map = (Map)RecursionManager.doPreventingRecursion((Object)identifyingPsiElement, (boolean)false, () -> {
            if (springBean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor", "lambda$getAttributesWithoutRecursion$0"));
            }
            return this.getAttributes(springBean);
        });
        Map map2 = map != null ? map : Collections.emptyMap();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor", "getAttributesWithoutRecursion"));
        }
        return map2;
    }

    protected abstract PsiType getAttributeType(T var1);

    protected abstract SpringBeanAttributeDescriptor createAttributeDescriptor(String var1, T var2, String var3);

    protected abstract Map<String, T> getAttributes(@NotNull SpringBean var1);

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument doc) {
        if (XmlElementDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor", "getRootElementsDescriptors"));
        }
        return XmlElementDescriptor.EMPTY_ARRAY;
    }

    public XmlAttributeDescriptor[] getRootAttributeDescriptors(XmlTag context) {
        return this.getAttributeDescriptors(context);
    }

    protected static abstract class SpringBeanAttributeDescriptor<T extends PsiElement>
    implements XmlAttributeDescriptorEx,
    PsiPresentableMetaData {
        protected final String myAttributeName;
        protected final String mySuffix;
        protected final T myPsiElement;
        protected final String myNamespace;

        public SpringBeanAttributeDescriptor(@NonNls String attributeName, @NonNls String suffix, T t, String namespace) {
            this.myAttributeName = attributeName;
            this.mySuffix = suffix;
            this.myPsiElement = t;
            this.myNamespace = namespace;
        }

        public String getName() {
            return this.myAttributeName + this.mySuffix;
        }

        public void init(PsiElement element) {
            throw new UnsupportedOperationException("Method init is not yet implemented in " + this.getClass().getName());
        }

        public Object[] getDependences() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public PsiElement getDeclaration() {
            return this.myPsiElement;
        }

        @NonNls
        public String getName(PsiElement context) {
            String name = this.getName();
            String prefix = ((XmlTag)context).getPrefixByNamespace(this.myNamespace);
            name = (StringUtil.isNotEmpty((String)prefix) ? prefix + ":" : "") + name;
            return name;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isFixed() {
            return false;
        }

        public boolean hasIdType() {
            return false;
        }

        public boolean hasIdRefType() {
            return false;
        }

        @Nullable
        public String getDefaultValue() {
            return null;
        }

        public boolean isEnumerated() {
            return false;
        }

        public String[] getEnumeratedValues() {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }

        @Nullable
        public String validateValue(XmlElement context, String value) {
            return null;
        }

        public String getTypeName() {
            throw new UnsupportedOperationException("Method getTypeName is not yet implemented in " + this.getClass().getName());
        }

        @Nullable
        public Icon getIcon() {
            return SpringApiIcons.SpringProperty;
        }
    }

    protected static class CAttributeDescriptor
    extends SpringBeanAttributeDescriptor<PsiParameter> {
        public CAttributeDescriptor(@NonNls String attributeName, @NonNls String suffix, PsiParameter psiMethod, String namespace) {
            super(attributeName, suffix, psiMethod, namespace);
        }

        @NonNls
        public String handleTargetRename(@NotNull @NonNls String newTargetName) {
            if (newTargetName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTargetName", "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor$CAttributeDescriptor", "handleTargetRename"));
            }
            return newTargetName + this.mySuffix;
        }
    }

    protected static class PAttributeDescriptor
    extends SpringBeanAttributeDescriptor<PsiMethod> {
        public PAttributeDescriptor(@NonNls String attributeName, @NonNls String suffix, PsiMethod psiMethod, String namespace) {
            super(attributeName, suffix, psiMethod, namespace);
        }

        @NonNls
        public String handleTargetRename(@NotNull @NonNls String newTargetName) {
            if (newTargetName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTargetName", "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor$PAttributeDescriptor", "handleTargetRename"));
            }
            String propertyName = PropertyUtil.getPropertyName((String)newTargetName);
            return propertyName == null ? null : propertyName + this.mySuffix;
        }
    }
}

