/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.beans;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelWrapper;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomFileElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalXmlModelWrapper
extends LocalModelWrapper<LocalXmlModel> {
    private static final String FILE_PATH = "filePath=";

    LocalXmlModelWrapper(@NotNull LocalXmlModel element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/contexts/model/diagram/beans/LocalXmlModelWrapper", "<init>"));
        }
        super(element);
    }

    @Override
    protected void addImportsInformation(StringBuilder sb) {
        DomFileElement root = ((LocalXmlModel)this.myElement).getRoot();
        if (root != null) {
            LocalXmlModelWrapper.addTr(sb, "Imports", ((Beans)root.getRootElement()).getImports().size());
        }
    }

    @Override
    @NotNull
    protected String getLocalModelQualifiedName() {
        String string = ((XmlFile)((LocalXmlModel)this.myElement).getConfig()).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/beans/LocalXmlModelWrapper", "getLocalModelQualifiedName"));
        }
        return string;
    }

    @Override
    public String getTitle() {
        return ((XmlFile)((LocalXmlModel)this.myElement).getConfig()).getName();
    }

    @Override
    public String getQualifiedName() {
        return FILE_PATH + ((XmlFile)((LocalXmlModel)this.myElement).getConfig()).getVirtualFile().getPath();
    }

    @Nullable
    public static LocalXmlModelWrapper create(@Nullable LocalXmlModel element) {
        return element == null ? null : new LocalXmlModelWrapper(element);
    }

    @Nullable
    public static LocalModelGraphElementWrapper resolveByFQN(String fqn, Project project) {
        XmlFile file;
        if (fqn.startsWith(FILE_PATH) && (file = LocalXmlModelWrapper.findFile(project, fqn.substring(FILE_PATH.length() - 1))) != null) {
            return LocalXmlModelWrapper.create(SpringManager.getInstance((Project)project).getLocalSpringModel(file));
        }
        return null;
    }

    @Nullable
    protected static XmlFile findFile(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/contexts/model/diagram/beans/LocalXmlModelWrapper", "findFile"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)path)) {
            PsiFile psiFile;
            VirtualFile relativeFile;
            VirtualFile virtualFile = relativeFile = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance().findFileByPath(path) : VfsUtilCore.findRelativeFile((String)path, null);
            if (relativeFile != null && (psiFile = PsiManager.getInstance((Project)project).findFile(relativeFile)) instanceof XmlFile) {
                return (XmlFile)psiFile;
            }
        }
        return null;
    }
}

