/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.chooser;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsManager;
import com.intellij.spring.editor.SpringEditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LightColors;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import icons.SpringApiIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMultipleContextsPanel
extends SpringEditorNotificationPanel {
    private final PsiFile myPsiFile;
    private final List<SpringContextDescriptor> myDescriptors;

    public SpringMultipleContextsPanel(@NotNull PsiFile psiFile, @NotNull List<SpringContextDescriptor> descriptors, @NotNull SpringContextDescriptor currentContext) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/spring/contexts/chooser/SpringMultipleContextsPanel", "<init>"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/spring/contexts/chooser/SpringMultipleContextsPanel", "<init>"));
        }
        if (currentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentContext", "com/intellij/spring/contexts/chooser/SpringMultipleContextsPanel", "<init>"));
        }
        this.myPsiFile = psiFile;
        this.myDescriptors = descriptors;
        Set<Module> modules = SpringMultipleContextsPanel.getModules(descriptors);
        JPanel myDescriptorPanel = new JPanel(new FlowLayout(0, 0, 5));
        this.add(myDescriptorPanel, "West");
        myDescriptorPanel.setToolTipText(SpringBundle.message("multiple.context.tooltip.text", new Object[0]));
        myDescriptorPanel.add((Component)this.addChangeContextLabel(currentContext));
        if (modules.size() > 0) {
            SpringMultipleContextsPanel.addModuleLabel(myDescriptorPanel, currentContext);
        }
        SpringMultipleContextsPanel.addTotalContextsDescriptionLabel(myDescriptorPanel, descriptors, modules);
        myDescriptorPanel.setBackground(this.getBackground());
        this.installOpenEditorSettingsButton(psiFile.getProject());
    }

    private static void addTotalContextsDescriptionLabel(JPanel descriptorPanel, List<SpringContextDescriptor> descriptors, Set<Module> modules) {
        String message = modules.size() > 1 ? SpringBundle.message("multiple.context.description.in.modules.label.text", descriptors.size(), modules.size()) : SpringBundle.message("multiple.context.description.label.text", descriptors.size());
        SpringMultipleContextsPanel.addLabel(descriptorPanel, message, null);
    }

    private static void addModuleLabel(JPanel descriptorPanel, SpringContextDescriptor currentContext) {
        Module module = currentContext.getModule();
        if (module != null) {
            SpringMultipleContextsPanel.addLabel(descriptorPanel, SpringBundle.message("multiple.context.description.in.module.text", module.getName()), null);
        }
    }

    private static Set<Module> getModules(List<SpringContextDescriptor> descriptors) {
        LinkedHashSet modules = ContainerUtil.newLinkedHashSet();
        for (SpringContextDescriptor descriptor : descriptors) {
            Module module = descriptor.getModule();
            if (module == null) continue;
            modules.add(module);
        }
        return modules;
    }

    private HyperlinkLabel addChangeContextLabel(final SpringContextDescriptor currentContext) {
        final HyperlinkLabel label = new HyperlinkLabel(currentContext.getName(), this.getBackground());
        label.setIcon(SpringApiIcons.FileSet);
        label.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(HyperlinkEvent e) {
                JBList list = new JBList((Collection)SpringMultipleContextsPanel.this.myDescriptors);
                list.installCellRenderer(obj -> {
                    JPanel panel = new JPanel(new BorderLayout());
                    SpringContextDescriptor contextDescriptor = (SpringContextDescriptor)obj;
                    Icon icon = contextDescriptor.equals((Object)currentContext) ? AllIcons.Actions.Checked : EmptyIcon.create((Icon)AllIcons.Actions.Checked);
                    String name1 = contextDescriptor.getName();
                    if (contextDescriptor.isPredefinedContext()) {
                        name1 = "<html><b>" + name1 + "</b></html>";
                    }
                    JLabel descriptorLabel = new JLabel(name1, icon, 2);
                    descriptorLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)10));
                    panel.add((Component)descriptorLabel, "West");
                    Module module = contextDescriptor.getModule();
                    if (module != null) {
                        JPanel modulePanel = new JPanel(new BorderLayout());
                        modulePanel.setOpaque(false);
                        modulePanel.add((Component)new JLabel("    " + module.getName()), "West");
                        JLabel iconLabel = new JLabel("", ModuleType.get((Module)module).getIcon(), 2);
                        iconLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)2, (int)0, (int)2));
                        modulePanel.add((Component)iconLabel, "East");
                        panel.add((Component)modulePanel, "East");
                    }
                    panel.setBorder(IdeBorderFactory.createEmptyBorder((int)1, (int)1, (int)1, (int)1));
                    return panel;
                });
                JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setItemChoosenCallback(() -> {
                    Object value = list.getSelectedValue();
                    if (value instanceof SpringContextDescriptor) {
                        SpringMultipleContextsPanel.this.saveSelectedContext((SpringContextDescriptor)value);
                        Project project = SpringMultipleContextsPanel.this.myPsiFile.getProject();
                        EditorNotifications.getInstance((Project)project).updateAllNotifications();
                        SpringModificationTrackersManager.getInstance((Project)project).fireMultipleContextsChanged();
                        ((PsiModificationTrackerImpl)SpringMultipleContextsPanel.this.myPsiFile.getManager().getModificationTracker()).incCounter();
                        DaemonCodeAnalyzer.getInstance((Project)project).restart();
                    }
                }).setFilteringEnabled(o -> {
                    if (!(o instanceof SpringContextDescriptor)) {
                        return null;
                    }
                    SpringContextDescriptor descriptor = (SpringContextDescriptor)o;
                    Module module = descriptor.getModule();
                    return module != null ? descriptor.getName() + " " + module.getName() : descriptor.getName();
                }).createPopup();
                DataContext context = DataManager.getInstance().getDataContext((Component)label);
                popup.showInBestPositionFor(context);
            }
        });
        return label;
    }

    private void saveSelectedContext(@NotNull SpringContextDescriptor value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/contexts/chooser/SpringMultipleContextsPanel", "saveSelectedContext"));
        }
        SpringMultipleContextsManager.getInstance().persistDescriptor(this.myPsiFile, value);
    }

    private static void addLabel(@NotNull JPanel panel, @NotNull String s, @Nullable Icon icon) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/spring/contexts/chooser/SpringMultipleContextsPanel", "addLabel"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/contexts/chooser/SpringMultipleContextsPanel", "addLabel"));
        }
        panel.add(new JLabel(s, icon, 2));
    }

    public Color getBackground() {
        return LightColors.SLIGHTLY_GREEN;
    }
}

