/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.livetemplate;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssLiveTemplateContextType
extends TemplateContextType {
    protected CssLiveTemplateContextType(@NonNls String id, @NonNls String contextName, @Nullable Class<? extends TemplateContextType> baseContextType) {
        super(id, contextName, baseContextType);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/livetemplate/CssLiveTemplateContextType", "isInContext"));
        }
        if (PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset).isKindOf((Language)CSSLanguage.INSTANCE)) {
            PsiElement elementAt = file.findElementAt(offset);
            if (elementAt == null) {
                return false;
            }
            if (elementAt instanceof PsiComment) {
                return this.availableInComment();
            }
            PsiElement element = CssLiveTemplateContextType.getFirstCompositeElement(elementAt);
            return element != null && this.isInContext(element);
        }
        return false;
    }

    protected boolean availableInComment() {
        return false;
    }

    @Nullable
    private static PsiElement getFirstCompositeElement(@Nullable PsiElement at) {
        PsiElement result;
        for (result = at; result != null && (result instanceof PsiWhiteSpace || result.getChildren().length == 0); result = result.getParent()) {
        }
        return result;
    }

    protected abstract boolean isInContext(@NotNull PsiElement var1);

    public SyntaxHighlighter createHighlighter() {
        return new CssHighlighter();
    }
}

